/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.aksw.commons.collections.ListIteratorUtils;

public class FilteringListIterator<T, I extends ListIterator<T>>
implements ListIterator<T> {
    protected I core;
    protected Predicate<? super T> predicate;
    protected int currentIndex;
    protected boolean wasPreviousOrNextCalled = false;

    public void setWasPreviousOrNextCalled(boolean flag) {
        this.wasPreviousOrNextCalled = flag;
    }

    public FilteringListIterator(I core, Predicate<? super T> predicate, int currentIndex) {
        this.core = core;
        this.predicate = predicate;
        this.currentIndex = currentIndex;
    }

    public static void checkDistance(int distance) {
        if (distance == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasNext() {
        int distance = ListIteratorUtils.distanceToNext(this.core, this::test).getKey();
        ListIteratorUtils.repeatPrevious(this.core, distance);
        boolean result = distance > 0;
        return result;
    }

    @Override
    public T next() {
        this.wasPreviousOrNextCalled = true;
        Map.Entry<Integer, Object> e = ListIteratorUtils.distanceToNext(this.core, this::test);
        int distance = e.getKey();
        FilteringListIterator.checkDistance(distance);
        ++this.currentIndex;
        Object result = e.getValue();
        return (T)result;
    }

    @Override
    public void remove() {
        if (!this.wasPreviousOrNextCalled) {
            throw new IllegalStateException(".remove() requires positioning on a valid element using .previous() or .next()");
        }
        this.core.remove();
        this.wasPreviousOrNextCalled = false;
    }

    @Override
    public boolean hasPrevious() {
        int distance = ListIteratorUtils.distanceToPrevious(this.core, this::test).getKey();
        ListIteratorUtils.repeatNext(this.core, distance);
        boolean result = distance > 0;
        return result;
    }

    @Override
    public T previous() {
        this.wasPreviousOrNextCalled = true;
        Map.Entry<Integer, Object> e = ListIteratorUtils.distanceToPrevious(this.core, this::test);
        int distance = e.getKey();
        FilteringListIterator.checkDistance(distance);
        --this.currentIndex;
        Object result = e.getValue();
        return (T)result;
    }

    @Override
    public int nextIndex() {
        int distance = ListIteratorUtils.distanceToNext(this.core, this::test).getKey();
        int result = distance > 0 ? this.currentIndex + 1 : this.currentIndex;
        return result;
    }

    @Override
    public int previousIndex() {
        int distance = ListIteratorUtils.distanceToPrevious(this.core, this::test).getKey();
        int result = distance > 0 ? this.currentIndex - 1 : this.currentIndex;
        return result;
    }

    @Override
    public void set(T e) {
        this.core.set(e);
    }

    @Override
    public void add(T e) {
        if (!this.test(e)) {
            throw new IllegalArgumentException("Failed to add item because of rejection by filter. Item: " + String.valueOf(e));
        }
        this.core.add(e);
    }

    protected boolean test(T item) {
        boolean result = this.predicate.test(item);
        return result;
    }
}

