/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.base.Converter;
import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.FilteringListIterator;
import org.aksw.commons.collections.ListIteratorUtils;
import org.aksw.commons.collections.MutableCollectionViews;

public class FilteringList<T, C extends List<T>>
extends AbstractList<T> {
    protected C backend;
    protected Predicate<? super T> predicate;

    public FilteringList(C backend, Predicate<? super T> predicate) {
        this.backend = backend;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        ListIterator core = this.backend.listIterator();
        FilteringListIterator result = new FilteringListIterator(core, this.predicate, index - 1);
        int reachedIndex = ListIteratorUtils.repeatNext(result, index);
        if (index > reachedIndex) {
            throw new IndexOutOfBoundsException("Requested index " + index + " in list of size " + reachedIndex);
        }
        result.setWasPreviousOrNextCalled(false);
        return result;
    }

    @Override
    public boolean add(T e) {
        return super.add(e);
    }

    @Override
    public void add(int index, T element) {
        ListIterator<T> it = this.listIterator(index);
        it.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int size = this.size();
        return this.addAll(size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result;
        boolean bl = result = !c.isEmpty();
        if (result) {
            ListIterator<T> it = this.listIterator(index);
            for (T item : c) {
                it.add(item);
            }
        }
        return result;
    }

    @Override
    public T set(int index, T element) {
        ListIterator<T> it = this.listIterator(index);
        it.next();
        it.set(element);
        return element;
    }

    @Override
    public T get(int index) {
        ListIterator<T> it = this.listIterator(index);
        T result = it.next();
        return result;
    }

    @Override
    public int size() {
        int result = Iterators.size(this.listIterator());
        return result;
    }

    public static <F, B, C extends Collection<B>> Collection<F> createSafe(Collection<B> backend, Converter<B, F> converter) {
        Collection<B> safeBackend = MutableCollectionViews.filteringCollection(backend, converter);
        ConvertingCollection<F, B, Collection<B>> result = new ConvertingCollection<F, B, Collection<B>>(safeBackend, converter);
        return result;
    }
}

