/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.rangeset;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.commons.collection.rangeset.AsRangesBase;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.commons.util.range.Endpoint;
import org.aksw.commons.util.range.RangeUtils;

public class RangeSetUtils {
    public static <T extends Comparable<T>> Collection<Range<T>> intersection(RangeSet<T> a, RangeSet<T> b) {
        return RangeSetUtils.difference(a, b.complement());
    }

    public static <T extends Comparable<T>> Collection<Range<T>> getRangesBeforeAndAfter(RangeSet<T> rangeSet, T value) {
        Range before = (Range)Iterables.getFirst((Iterable)rangeSet.subRangeSet(Range.atMost(value)).asDescendingSetOfRanges(), null);
        Range after = (Range)Iterables.getFirst((Iterable)rangeSet.subRangeSet(Range.atLeast(value)).asRanges(), null);
        Collection<Object> result = before == null ? (after == null ? Collections.emptyList() : Collections.singleton(after)) : (after == null ? Collections.singleton(before) : (before.isConnected(after) ? Collections.singletonList(before.span(after)) : ImmutableList.builder().add((Object)before).add((Object)after).build()));
        return result;
    }

    public static <T extends Comparable<T>> Set<Range<T>> difference(final RangeSet<T> aset, final RangeSet<T> bset) {
        return new AbstractSet<Range<T>>(){

            @Override
            public Iterator<Range<T>> iterator() {
                return new PrefetchIterator<Range<T>>(this){
                    Iterator<Range<T>> ait;
                    RangeSet<T> bComplement;
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.ait = aset.asRanges().iterator();
                        this.bComplement = bset.complement();
                    }

                    @Override
                    protected Iterator<Range<T>> prefetch() {
                        Iterator r = null;
                        if (this.ait.hasNext()) {
                            Range a = this.ait.next();
                            r = this.bComplement.subRangeSet(a).asRanges().iterator();
                        }
                        return r;
                    }
                };
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    public static <T extends Comparable<T>> Set<Range<T>> symmetricDifference(RangeSet<T> aset, RangeSet<T> bset) {
        Set<Range<T>> added = RangeSetUtils.difference(aset, bset);
        Set<Range<T>> removed = RangeSetUtils.difference(bset, aset);
        return new AsRangesBase<T>(added, removed, RangeUtils::compareToLowerBound);
    }

    public static <T extends Comparable<T>> Set<Range<T>> complementAsRanges(RangeSet<T> set, Range<T> restriction) {
        return RangeSetUtils.complement(() -> set.subRangeSet(restriction).asRanges().iterator(), RangeUtils::getLowerEndpoint, RangeUtils::getUpperEndpoint, RangeUtils::create, restriction);
    }

    public static <T extends Comparable<T>> Set<Range<T>> complementAsDescendingSetOfRanges(RangeSet<T> set, Range<T> restriction) {
        return RangeSetUtils.complement(() -> set.subRangeSet(restriction).asDescendingSetOfRanges().iterator(), RangeUtils::getUpperEndpoint, RangeUtils::getLowerEndpoint, (hi, lo) -> RangeUtils.create((Endpoint)lo, (Endpoint)hi), restriction);
    }

    public static <T extends Comparable<T>> Set<Range<T>> complement(final Supplier<Iterator<Range<T>>> iteratorSupp, final Function<Range<T>, Endpoint<T>> getNearerEndpoint, final Function<Range<T>, Endpoint<T>> getFartherEndpoint, final BiFunction<Endpoint<T>, Endpoint<T>, Range<T>> createRange, final Range<T> restriction) {
        return new AbstractSet<Range<T>>(){

            @Override
            public Iterator<Range<T>> iterator() {
                return new AbstractIterator<Range<T>>(this){
                    Iterator<Range<T>> it;
                    Endpoint<T> lastEndpoint;
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                        this.it = (Iterator)iteratorSupp.get();
                        this.lastEndpoint = (Endpoint)getNearerEndpoint.apply(restriction);
                    }

                    protected Range<T> computeNext() {
                        Range r;
                        block3: {
                            Endpoint ae;
                            Endpoint tmp;
                            r = null;
                            do {
                                tmp = this.lastEndpoint;
                                if (this.it == null) {
                                    r = (Range)this.endOfData();
                                    break block3;
                                }
                                if (this.it.hasNext()) {
                                    Range a = this.it.next();
                                    ae = ((Endpoint)getNearerEndpoint.apply(a)).toggleBoundType();
                                    this.lastEndpoint = ((Endpoint)getFartherEndpoint.apply(a)).toggleBoundType();
                                    continue;
                                }
                                ae = (Endpoint)getFartherEndpoint.apply(restriction);
                                this.it = null;
                            } while (tmp.equals((Object)ae) && this.it != null);
                            r = (Range)createRange.apply(tmp, ae);
                        }
                        return r;
                    }
                };
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }
}

