/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.rangeset;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.aksw.commons.collection.rangeset.RangeSetUtils;

public class RangeSetComplement<T extends Comparable<T>>
implements RangeSet<T> {
    protected RangeSet<T> rangeSet;
    protected Range<T> restriction;

    public RangeSetComplement(RangeSet<T> rangeSet, Range<T> restriction) {
        this.rangeSet = rangeSet;
        this.restriction = restriction;
    }

    public boolean contains(T value) {
        return !this.rangeSet.contains(value);
    }

    public Range<T> rangeContaining(T value) {
        Range result = RangeSetUtils.getRangesBeforeAndAfter(this, value).stream().filter(range -> range.contains(value)).findFirst().orElse(null);
        return result;
    }

    public boolean intersects(Range<T> otherRange) {
        return !this.subRangeSet(otherRange).isEmpty();
    }

    public boolean encloses(Range<T> otherRange) {
        throw new UnsupportedOperationException();
    }

    public boolean enclosesAll(RangeSet<T> other) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return !this.rangeSet.isEmpty();
    }

    public Range<T> span() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Range first = (Range)Iterables.getFirst(this.asRanges(), null);
        Range last = (Range)Iterables.getFirst(this.asDescendingSetOfRanges(), null);
        Range result = first.span(last);
        return result;
    }

    public Set<Range<T>> asRanges() {
        return RangeSetUtils.complementAsRanges(this.rangeSet, this.restriction);
    }

    public Set<Range<T>> asDescendingSetOfRanges() {
        return RangeSetUtils.complementAsDescendingSetOfRanges(this.rangeSet, this.restriction);
    }

    public RangeSet<T> complement() {
        throw new UnsupportedOperationException();
    }

    public RangeSet<T> subRangeSet(Range<T> view) {
        return new RangeSetComplement<T>(this.rangeSet, view);
    }

    public void add(Range<T> range) {
        this.rangeSet.remove(range);
    }

    public void remove(Range<T> range) {
        this.rangeSet.add(range);
    }

    public void clear() {
        this.rangeSet.add(Range.all());
    }

    public void addAll(RangeSet<T> other) {
        this.rangeSet.removeAll(other);
    }

    public void removeAll(RangeSet<T> other) {
        this.rangeSet.addAll(other);
    }

    public String toString() {
        return this.asRanges().toString();
    }
}

