/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.Registration;

public class ObservableValueFromObservableCollection<T, U>
implements ObservableValue<T> {
    protected ObservableCollection<U> delegate;
    protected Function<? super Collection<? extends U>, ? extends T> xform;
    protected Function<? super T, ? extends U> valueToItem;

    public ObservableValueFromObservableCollection(ObservableCollection<U> delegate, Function<? super Collection<? extends U>, ? extends T> xform, Function<? super T, ? extends U> valueToItem) {
        this.delegate = delegate;
        this.xform = xform;
        this.valueToItem = valueToItem;
    }

    public static <T> T getOnlyElementOrNull(Iterable<T> iterable) {
        T result;
        Iterator<T> it = iterable.iterator();
        T t = result = it.hasNext() ? (T)it.next() : null;
        if (it.hasNext()) {
            result = null;
        }
        return result;
    }

    @Override
    public T get() {
        T result = this.xform.apply(this.delegate);
        return result;
    }

    @Override
    public void set(T value) {
        T oldValue = this.get();
        if (!Objects.equals(oldValue, value)) {
            this.delegate.clear();
            U item = this.valueToItem.apply(value);
            if (item != null) {
                this.delegate.add(item);
            }
        }
    }

    public static <T, U> PropertyChangeListener wrapListener(Object self, PropertyChangeListener listener, Function<? super Collection<? extends U>, ? extends T> xform) {
        return ev -> {
            Object oldValue = Optional.ofNullable((Collection)ev.getOldValue()).map(xform).orElse(null);
            Object newValue = Optional.ofNullable((Collection)ev.getNewValue()).map(xform).orElse(null);
            PropertyChangeEvent newEv = new PropertyChangeEvent(self, "value", oldValue, newValue);
            listener.propertyChange(newEv);
        };
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        return this.delegate.addPropertyChangeListener(ObservableValueFromObservableCollection.wrapListener(this, listener, this.xform));
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public static <T> ObservableValue<T> decorate(ObservableCollection<T> delegate) {
        return new ObservableValueFromObservableCollection<Object, Object>(delegate, ObservableValueFromObservableCollection::getOnlyElementOrNull, x -> x);
    }
}

