/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import com.google.common.base.Converter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Objects;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.Registration;

public class ObservableConvertingValue<F, B>
implements ObservableValue<F> {
    protected ObservableValue<B> delegate;
    protected Converter<B, F> converter;

    public ObservableConvertingValue(ObservableValue<B> delegate, Converter<B, F> converter) {
        this.delegate = delegate;
        this.converter = converter;
    }

    @Override
    public F get() {
        Object b = this.delegate.get();
        Object result = this.converter.convert(b);
        return (F)result;
    }

    @Override
    public void set(F value) {
        Object b = this.converter.reverse().convert(value);
        this.delegate.set(b);
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        return this.delegate.addPropertyChangeListener(ev -> {
            Object rawOldValue = ev.getOldValue();
            Object rawNewValue = ev.getNewValue();
            Object oldValue = this.converter.convert(rawOldValue);
            Object newValue = this.converter.convert(rawNewValue);
            if (oldValue != null && newValue != null && !Objects.equals(oldValue, newValue)) {
                listener.propertyChange(new PropertyChangeEvent(this, "value", oldValue, newValue));
            }
        });
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        throw new UnsupportedOperationException();
    }
}

