/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.aksw.commons.collection.observable.PredicateFromMultisetOfDiscardedItems;
import org.aksw.commons.collections.CollectionFromIterable;

public class CollectionOps {
    public static <T> Collection<T> unionCore(Collection<T> a, Collection<T> b) {
        return CollectionFromIterable.wrap(Iterables.concat(a, b));
    }

    public static <T> Collection<T> differenceCore(Collection<T> base, T removedItem) {
        Collection<T> result = CollectionOps.differenceCore(base, Collections.singleton(removedItem));
        return result;
    }

    public static <T> Collection<T> differenceCore(Collection<T> base, Collection<T> removedItems) {
        Collection result = CollectionFromIterable.wrap(() -> Iterators.filter(base.iterator(), PredicateFromMultisetOfDiscardedItems.create(HashMultiset.create((Iterable)removedItems))::test));
        return result;
    }

    public static <T> Collection<T> smartDifference(Collection<T> base, Collection<T> removedItem) {
        Sets.SetView result = base instanceof Set && removedItem instanceof Set ? Sets.difference((Set)((Set)base), (Set)((Set)removedItem)) : CollectionOps.differenceCore(base, removedItem);
        return result;
    }

    public static <T> Collection<T> smartUnion(Collection<T> base, Collection<T> addedItems) {
        Sets.SetView result = base instanceof Set && addedItems instanceof Set ? Sets.union((Set)((Set)base), (Set)((Set)addedItems)) : CollectionOps.unionCore(base, addedItems);
        return result;
    }
}

