/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.accessors;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.commons.accessors.LazyCollection;
import org.aksw.commons.accessors.SingleValuedAccessor;
import org.aksw.commons.accessors.SingleValuedAccessorImpl;

public class LazyMap<K, V, C extends Map<K, V>>
extends AbstractMap<K, V> {
    protected SingleValuedAccessor<C> accessor;
    protected Supplier<? extends C> ctor;
    protected boolean setNullOnEmpty;
    public static Set<String> test;

    public LazyMap(SingleValuedAccessor<C> accessor, Supplier<? extends C> ctor) {
        this(accessor, ctor, true);
    }

    public LazyMap(SingleValuedAccessor<C> accessor, Supplier<? extends C> ctor, boolean setNullOnEmpty) {
        this.accessor = accessor;
        this.ctor = ctor;
        this.setNullOnEmpty = setNullOnEmpty;
    }

    @Override
    public V put(K k, V v) {
        Map backend = (Map)this.accessor.get();
        if (backend == null) {
            backend = (Map)this.ctor.get();
            this.accessor.set(backend);
        }
        backend.put(k, v);
        this.checkUnset(backend);
        return v;
    }

    public void checkUnset(C backend) {
        if (this.setNullOnEmpty && backend.isEmpty()) {
            this.accessor.set(null);
        }
    }

    @Override
    public boolean remove(Object k, Object v) {
        Map backend = (Map)this.accessor.get();
        boolean result = backend == null ? false : backend.remove(k, v);
        this.checkUnset(backend);
        return result;
    }

    @Override
    public boolean containsKey(Object k) {
        Map backend = (Map)this.accessor.get();
        boolean result = backend == null ? false : backend.containsKey(k);
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map backend = (Map)this.accessor.get();
        Set set = Optional.ofNullable(backend).orElse(Collections.emptyMap()).entrySet();
        return set;
    }

    @Override
    public int size() {
        Map backend = (Map)this.accessor.get();
        int result = backend == null ? 0 : backend.size();
        return result;
    }

    public static void main(String[] args) {
        SingleValuedAccessorImpl<Set> accessor = new SingleValuedAccessorImpl<Set>(() -> LazyCollection.test, val -> {
            LazyCollection.test = val;
        });
        LazyCollection tmp = new LazyCollection(accessor, HashSet::new, true);
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Adding item");
        tmp.add("Hello");
        System.out.println("Adding item");
        tmp.add("World");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Removing item");
        tmp.remove("World");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Removing item");
        tmp.remove("Hello");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Adding item");
        tmp.add("World");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Clearing");
        tmp.clear();
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
    }
}

