/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.accessors;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Objects;
import org.aksw.commons.accessors.SingleValuedAccessor;
import org.aksw.commons.collections.SinglePrefetchIterator;

public class CollectionFromSingleValuedAccessor<T>
extends AbstractCollection<T> {
    protected SingleValuedAccessor<T> accessor;

    public CollectionFromSingleValuedAccessor(SingleValuedAccessor<T> accessor) {
        Objects.requireNonNull(accessor);
        this.accessor = accessor;
    }

    @Override
    public boolean add(T e) {
        Objects.requireNonNull(e);
        T value = this.accessor.get();
        if (value != null && value != e) {
            throw new RuntimeException("Cannot add because a value already exists: " + String.valueOf(value));
        }
        this.accessor.set(e);
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new SinglePrefetchIterator<T>(){
            T value;
            int emitted;
            {
                this.value = CollectionFromSingleValuedAccessor.this.accessor.get();
                this.emitted = 0;
            }

            @Override
            protected T prefetch() throws Exception {
                return this.emitted++ != 0 || this.value == null ? this.finish() : this.value;
            }

            @Override
            protected void doRemove(T item) {
                CollectionFromSingleValuedAccessor.this.accessor.set(null);
            }
        };
    }

    @Override
    public int size() {
        T value = this.accessor.get();
        int result = value == null ? 0 : 1;
        return result;
    }
}

