/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.sets;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SetFromCollectionUnsafe<T>
extends AbstractSet<T> {
    protected Collection<T> backend;

    public SetFromCollectionUnsafe(Collection<T> backend) {
        this.backend = backend;
    }

    @Override
    public boolean add(T e) {
        boolean result = this.backend.contains(e) ? false : this.backend.add(e);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.backend.remove(o);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = this.backend.contains(o);
        return result;
    }

    @Override
    public void clear() {
        this.backend.clear();
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> result = this.backend.iterator();
        return result;
    }

    @Override
    public int size() {
        int result = this.backend.size();
        return result;
    }

    public static <T> Set<T> wrapIfNeeded(Collection<T> collection) {
        Set<Object> result = collection instanceof Set ? (Set<Object>)collection : new SetFromCollectionUnsafe<T>(collection);
        return result;
    }
}

