/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.selector;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aksw.commons.collections.selector.WeightedSelector;

public abstract class WeightedSelectorMutableBase<T>
implements WeightedSelector<T> {
    protected List<Map.Entry<T, ? extends Number>> entries;
    protected double nextOffset;

    @Override
    public abstract WeightedSelectorMutableBase<T> clone();

    public static double eps(double d) {
        double e = 1.0E-5;
        return d >= 0.0 && d < e ? e : d;
    }

    public WeightedSelectorMutableBase() {
        this(new ArrayList<Map.Entry<T, ? extends Number>>());
    }

    public WeightedSelectorMutableBase(List<Map.Entry<T, ? extends Number>> entries) {
        this.entries = entries;
        this.nextOffset = entries.stream().map(Map.Entry::getValue).mapToDouble(Number::doubleValue).sum();
    }

    public Map.Entry<Integer, Map.Entry<T, ? extends Number>> sampleEntryWithIndex(Number t) {
        double d = Objects.requireNonNull(t).doubleValue();
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Argument must be in the interval [0, 1]");
        }
        double key = d * this.nextOffset;
        double current = 0.0;
        Map.Entry<T, Number> match = null;
        int i = -1;
        Iterator<Map.Entry<T, Number>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, Number> e;
            match = e = iterator.next();
            ++i;
            double next = current + WeightedSelectorMutableBase.eps(e.getValue().doubleValue());
            if (key < next) break;
            current = next;
        }
        Map.Entry result = match == null ? null : Maps.immutableEntry((Object)i, match);
        return result;
    }

    @Override
    public Map.Entry<T, ? extends Number> sampleEntry(Number t) {
        Map.Entry<Integer, Map.Entry<T, Number>> e = this.sampleEntryWithIndex(t);
        Map.Entry<T, Number> result = e == null ? null : e.getValue();
        return result;
    }

    @Override
    public Collection<Map.Entry<T, ? extends Number>> entries() {
        return this.entries;
    }

    public void put(T item, Number weight) {
        this.put(Maps.immutableEntry(item, (Object)weight));
    }

    public void put(Map.Entry<T, ? extends Number> e) {
        if (e.getValue().doubleValue() < 0.0) {
            throw new IllegalArgumentException("Negative weights are not supported; got: " + String.valueOf(e));
        }
        this.entries.add(e);
        this.nextOffset += WeightedSelectorMutableBase.eps(e.getValue().doubleValue());
    }

    public void putAll(Collection<? extends Map.Entry<T, ? extends Number>> items) {
        for (Map.Entry<T, Number> entry : items) {
            this.put(entry);
        }
    }

    public boolean remove(Object e) {
        boolean result = this.entries.removeIf(item -> Objects.equals(item, e));
        return result;
    }
}

