/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.maps;

import com.google.common.base.Converter;
import java.util.Map;
import java.util.function.Function;

public class EntryConverterByKey<K, L, V>
extends Converter<Map.Entry<K, V>, Map.Entry<L, V>> {
    protected Converter<K, L> converter;

    public EntryConverterByKey(Converter<K, L> converter) {
        this.converter = converter;
    }

    protected Map.Entry<L, V> doForward(Map.Entry<K, V> a) {
        return EntryConverterByKey.transformKey(a, arg_0 -> this.converter.convert(arg_0));
    }

    protected Map.Entry<K, V> doBackward(Map.Entry<L, V> b) {
        return EntryConverterByKey.transformKey(b, arg_0 -> ((Converter)this.converter.reverse()).convert(arg_0));
    }

    public static <K, L, V> Converter<Map.Entry<K, V>, Map.Entry<L, V>> converterByKey(Converter<K, L> converter) {
        return Converter.from(a -> EntryConverterByKey.transformKey(a, arg_0 -> ((Converter)converter).convert(arg_0)), b -> EntryConverterByKey.transformKey(b, arg_0 -> ((Converter)converter.reverse()).convert(arg_0)));
    }

    public static <K, V, W> Converter<Map.Entry<K, V>, Map.Entry<K, W>> converterByValue(Converter<V, W> converter) {
        return Converter.from(a -> EntryConverterByKey.transformValue(a, converter), b -> EntryConverterByKey.transformValue(b, converter.reverse()));
    }

    public static <K, L, V> Map.Entry<L, V> transformKey(final Map.Entry<K, V> e, Function<? super K, ? extends L> fn) {
        final L key = fn.apply(e.getKey());
        return new Map.Entry<L, V>(){

            @Override
            public L getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return e.getValue();
            }

            @Override
            public V setValue(V v) {
                return e.setValue(v);
            }
        };
    }

    public static <K, V, W> Map.Entry<K, W> transformValue(final Map.Entry<K, V> e, final Converter<V, W> converter) {
        final K key = e.getKey();
        return new Map.Entry<K, W>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public W getValue() {
                Object raw = e.getValue();
                Object r = converter.convert(raw);
                return r;
            }

            @Override
            public W setValue(W v) {
                Object raw = converter.reverse().convert(v);
                e.setValue(raw);
                return v;
            }
        };
    }
}

