/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.lists;

import java.util.ListIterator;
import java.util.Objects;

public class ReverseListIterator<T>
implements ListIterator<T> {
    protected ListIterator<T> delegate;

    public ReverseListIterator(ListIterator<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public static <T> ListIterator<T> of(ListIterator<T> it) {
        return new ReverseListIterator<T>(it);
    }

    protected ListIterator<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean hasNext() {
        return this.getDelegate().hasPrevious();
    }

    @Override
    public T next() {
        return this.getDelegate().previous();
    }

    @Override
    public boolean hasPrevious() {
        return this.getDelegate().hasNext();
    }

    @Override
    public T previous() {
        return this.getDelegate().next();
    }

    @Override
    public int nextIndex() {
        return this.getDelegate().previousIndex();
    }

    @Override
    public int previousIndex() {
        return this.getDelegate().nextIndex();
    }

    @Override
    public void remove() {
        ListIterator<T> d = this.getDelegate();
        d.remove();
    }

    @Override
    public void set(T e) {
        this.getDelegate().add(e);
    }

    @Override
    public void add(T e) {
        ListIterator<T> d = this.getDelegate();
        d.add(e);
        d.previous();
    }
}

