/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.generator;

import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.collections.generator.GeneratorFilter;
import org.aksw.commons.collections.generator.GeneratorFromFunction;
import org.aksw.commons.collections.generator.GeneratorTransforming;

public interface Generator<T> {
    public T next();

    public T current();

    public Generator<T> clone();

    default public <O> Generator<O> map(Function<? super T, O> fn) {
        return new GeneratorTransforming<O, T>(this, fn);
    }

    default public Generator<?> filterKeep(Predicate<? super T> predicate) {
        return new GeneratorFilter<T>(this, predicate);
    }

    default public Generator<T> filterDrop(Predicate<? super T> predicate) {
        return new GeneratorFilter<Object>(this, item -> !predicate.test(item));
    }

    public static Generator<String> create(String prefix) {
        return GeneratorFromFunction.createInt().map(value -> prefix + "_" + value);
    }
}

