/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.ForwardingSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.commons.collections.CollectionUtils;

public class SetUtils {
    public static <T> Set<T> asSet(Iterable<T> c) {
        return c instanceof Set ? (Set)c : (Set)CollectionUtils.newCollection(LinkedHashSet::new, c);
    }

    public static <T> Set<T> newLinkedHashSet(Iterator<? extends T> c) {
        return CollectionUtils.newCollection(LinkedHashSet::new, c);
    }

    public static <K, V> Set<V> mapSet(Set<K> set, Map<K, V> map) {
        HashSet<V> result = new HashSet<V>();
        for (K item : set) {
            V v = map.get(item);
            result.add(v);
        }
        return result;
    }

    public static <T> Set<T> newForwardingSet(final Supplier<? extends Set<T>> setSupplier) {
        return new ForwardingSet<T>(){

            protected Set<T> delegate() {
                return (Set)setSupplier.get();
            }
        };
    }
}

