/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Sample<T> {
    private Set<T> positives;
    private Set<T> negatives;

    public static <T> Sample<T> create() {
        return new Sample(new HashSet(), new HashSet());
    }

    public static <T> Sample<T> createCopy(Sample<T> other) {
        return Sample.createCopy(other.getPositives(), other.getNegatives());
    }

    public static <T> Sample<T> createCopy(Collection<T> positives, Collection<T> negatives) {
        return new Sample<T>(new HashSet<T>(positives), negatives == null ? null : new HashSet<T>(negatives));
    }

    public static <T> Sample<T> create(Sample<T> other) {
        return Sample.create(other.getPositives(), other.getNegatives());
    }

    public static <T> Sample<T> create(Set<T> positives, Set<T> negatives) {
        return new Sample<T>(positives, negatives);
    }

    public Sample(Set<T> positives, Set<T> negatives) {
        this.positives = positives;
        this.negatives = negatives;
    }

    public Set<T> getPositives() {
        return this.positives;
    }

    public Set<T> getNegatives() {
        return this.negatives;
    }

    public void addAll(Sample<T> other) {
        this.addAll(other.getPositives(), other.getNegatives());
    }

    public void addAll(Collection<? extends T> positives, Collection<? extends T> negatives) {
        this.positives.addAll(positives);
        this.negatives.addAll(negatives);
    }

    public void clear() {
        this.positives.clear();
        this.negatives.clear();
    }

    public boolean isEmpty() {
        return this.positives.isEmpty() && this.negatives.isEmpty();
    }

    public String toString() {
        return "Positives: " + String.valueOf(this.positives) + "\nNegatives: " + String.valueOf(this.negatives);
    }
}

