/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.aksw.commons.collections.FilteringIterator;

public class FilteringCollection<T, C extends Collection<T>>
extends AbstractCollection<T> {
    protected C backend;
    protected Predicate<? super T> predicate;

    public FilteringCollection(C backend, Predicate<? super T> predicate) {
        this.backend = backend;
        this.predicate = predicate;
    }

    public C getBackend() {
        return this.backend;
    }

    public Predicate<? super T> getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean add(T e) {
        if (!this.predicate.test(e)) {
            throw new IllegalArgumentException("add failed because item was rejected by predicate; violating item: " + String.valueOf(e));
        }
        boolean result = this.backend.add(e);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        boolean result;
        try {
            boolean accepted = this.predicate.test(o);
            result = accepted ? this.backend.contains(o) : false;
        }
        catch (ClassCastException e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result;
        try {
            boolean accepted = this.predicate.test(o);
            result = accepted ? this.backend.remove(o) : false;
        }
        catch (ClassCastException e) {
            result = false;
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator baseIt = this.backend.iterator();
        return new FilteringIterator(baseIt, this.predicate);
    }

    @Override
    public int size() {
        int result = Iterators.size(this.iterator());
        return result;
    }
}

