/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.base.Converter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.ConvertingListIterator;

public class ConvertingList<F, B, C extends List<B>>
extends ConvertingCollection<F, B, C>
implements List<F> {
    public ConvertingList(C backend, Converter<B, F> converter) {
        super(backend, converter);
    }

    @Override
    public boolean addAll(Collection<? extends F> c) {
        Collection transformed = c.stream().map(item -> this.converter.reverse().convert(item)).collect(Collectors.toList());
        boolean result = ((List)this.backend).addAll(transformed);
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends F> c) {
        Collection transformed = c.stream().map(item -> this.converter.reverse().convert(item)).collect(Collectors.toList());
        boolean result = ((List)this.backend).addAll(index, transformed);
        return result;
    }

    @Override
    public F get(int index) {
        Object raw = ((List)this.backend).get(index);
        Object result = this.converter.convert(raw);
        return (F)result;
    }

    @Override
    public F set(int index, F element) {
        Object raw = this.converter.reverse().convert(element);
        ((List)this.backend).set(index, raw);
        return element;
    }

    @Override
    public void add(int index, F element) {
        this.addAll(index, (Collection<? extends F>)Collections.singleton(element));
    }

    @Override
    public F remove(int index) {
        Object raw = ((List)this.backend).remove(index);
        Object result = this.converter.convert(raw);
        return (F)result;
    }

    @Override
    public int indexOf(Object o) {
        int result;
        try {
            Object front = o;
            Object raw = this.converter.reverse().convert(front);
            result = ((List)this.backend).indexOf(raw);
        }
        catch (ClassCastException e) {
            result = -1;
        }
        return result;
    }

    @Override
    public int lastIndexOf(Object o) {
        int result;
        try {
            Object front = o;
            Object raw = this.converter.reverse().convert(front);
            result = ((List)this.backend).lastIndexOf(raw);
        }
        catch (ClassCastException e) {
            result = -1;
        }
        return result;
    }

    @Override
    public ListIterator<F> listIterator() {
        ListIterator core = ((List)this.backend).listIterator();
        ConvertingListIterator result = new ConvertingListIterator(core, this.converter);
        return result;
    }

    @Override
    public ListIterator<F> listIterator(int index) {
        ListIterator core = ((List)this.backend).listIterator(index);
        ConvertingListIterator result = new ConvertingListIterator(core, this.converter);
        return result;
    }

    @Override
    public List<F> subList(int fromIndex, int toIndex) {
        List subList = ((List)this.backend).subList(fromIndex, toIndex);
        ConvertingList result = new ConvertingList(subList, this.converter);
        return result;
    }
}

