/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CartesianProductIterator<T>
implements Iterator<List<T>> {
    protected Iterable<? extends T>[] iterables;
    protected Iterator<? extends T>[] iterators;
    protected T[] current;
    protected T[] result;
    protected List<T> resultView;
    protected boolean inPlace = false;
    protected boolean hasNext = true;
    protected final int l;
    protected final int lMinusOne;
    protected int copyOffset;

    public CartesianProductIterator(Collection<? extends Iterable<? extends T>> collections) {
        this(false, collections);
    }

    public CartesianProductIterator(boolean inPlace, Collection<? extends Iterable<? extends T>> collections) {
        this(inPlace, collections.toArray(new Iterable[0]));
    }

    public CartesianProductIterator(Iterable<? extends T> ... iterables) {
        this(false, iterables);
    }

    public CartesianProductIterator(boolean inPlace, Iterable<? extends T> ... iterables) {
        this.inPlace = inPlace;
        this.l = iterables.length;
        this.lMinusOne = this.l - 1;
        this.iterables = iterables;
        this.init();
    }

    private void init() {
        this.iterators = new Iterator[this.l];
        this.current = new Object[this.l];
        this.result = new Object[this.l];
        if (this.l == 0) {
            this.hasNext = false;
        }
        for (int i = 0; i < this.l; ++i) {
            Iterator<T> it = this.iterables[i].iterator();
            this.iterators[i] = it;
            if (it.hasNext()) {
                T value = it.next();
                this.current[i] = value;
                continue;
            }
            this.hasNext = false;
        }
        this.copyOffset = 0;
        this.resultView = Arrays.asList(this.result);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public List<T> next() {
        for (int i = this.copyOffset; i < this.l; ++i) {
            this.result[i] = this.current[i];
        }
        this.copyOffset = this.lMinusOne;
        while (this.copyOffset >= 0) {
            Iterator<T> it = this.iterators[this.copyOffset];
            if (it.hasNext()) {
                T value = it.next();
                this.current[this.copyOffset] = value;
                break;
            }
            if (this.copyOffset == 0) {
                this.hasNext = false;
            }
            it = this.iterables[this.copyOffset].iterator();
            this.iterators[this.copyOffset] = it;
            this.current[this.copyOffset] = it.next();
            --this.copyOffset;
        }
        ArrayList<T> result = this.inPlace ? this.resultView : new ArrayList<T>(this.resultView);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

