/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.rangeset;

import com.google.common.base.Converter;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Set;
import org.aksw.commons.collections.ConvertingSet;
import org.aksw.commons.util.range.RangeUtils;

public class ConvertingRangeSet<T extends Comparable<T>, U extends Comparable<U>>
implements RangeSet<T> {
    protected Converter<U, T> endpointConverter;
    protected Converter<Range<U>, Range<T>> rangeConverter;
    protected RangeSet<U> backend;

    public static <I extends Comparable<I>, O extends Comparable<O>> Converter<Range<I>, Range<O>> createRangeConverter(Converter<I, O> endpointConverter) {
        return Converter.from(a -> RangeUtils.map((Range)a, arg_0 -> ((Converter)endpointConverter).convert(arg_0)), b -> RangeUtils.map((Range)b, arg_0 -> ((Converter)endpointConverter.reverse()).convert(arg_0)));
    }

    public ConvertingRangeSet(RangeSet<U> backend, Converter<U, T> endpointConverter) {
        this(backend, endpointConverter, ConvertingRangeSet.createRangeConverter(endpointConverter));
    }

    public ConvertingRangeSet(RangeSet<U> backend, Converter<U, T> endpointConverter, Converter<Range<U>, Range<T>> rangeConverter) {
        this.backend = backend;
        this.endpointConverter = endpointConverter;
        this.rangeConverter = rangeConverter;
    }

    public boolean contains(T value) {
        Comparable v = (Comparable)this.endpointConverter.reverse().convert(value);
        boolean result = this.backend.contains(v);
        return result;
    }

    public Range<T> rangeContaining(T value) {
        Comparable v = (Comparable)this.endpointConverter.reverse().convert(value);
        Range b = this.backend.rangeContaining(v);
        Range result = (Range)this.rangeConverter.convert((Object)b);
        return result;
    }

    public boolean intersects(Range<T> otherRange) {
        Range or = (Range)this.rangeConverter.reverse().convert(otherRange);
        boolean result = this.backend.intersects(or);
        return result;
    }

    public boolean encloses(Range<T> otherRange) {
        Range or = (Range)this.rangeConverter.reverse().convert(otherRange);
        boolean result = this.backend.encloses(or);
        return result;
    }

    public boolean enclosesAll(RangeSet<T> other) {
        boolean result = this.backend.enclosesAll(new ConvertingRangeSet<T, T>(other, this.endpointConverter.reverse(), this.rangeConverter.reverse()));
        return result;
    }

    public boolean isEmpty() {
        return this.backend.isEmpty();
    }

    public Range<T> span() {
        Range r = this.backend.span();
        Range result = (Range)this.rangeConverter.convert((Object)r);
        return result;
    }

    public Set<Range<T>> asRanges() {
        return new ConvertingSet<Range<T>, Range<U>, Set>(this.backend.asRanges(), this.rangeConverter);
    }

    public Set<Range<T>> asDescendingSetOfRanges() {
        return new ConvertingSet<Range<T>, Range<U>, Set>(this.backend.asDescendingSetOfRanges(), this.rangeConverter);
    }

    public RangeSet<T> complement() {
        return new ConvertingRangeSet<T, U>(this.backend.complement(), this.endpointConverter, this.rangeConverter);
    }

    public RangeSet<T> subRangeSet(Range<T> view) {
        Range r = (Range)this.rangeConverter.reverse().convert(view);
        return new ConvertingRangeSet<T, U>(this.backend.subRangeSet(r), this.endpointConverter, this.rangeConverter);
    }

    public void add(Range<T> range) {
        Range r = (Range)this.rangeConverter.reverse().convert(range);
        this.backend.add(r);
    }

    public void remove(Range<T> range) {
        Range r = (Range)this.rangeConverter.reverse().convert(range);
        this.backend.remove(r);
    }

    public void clear() {
        this.backend.clear();
    }

    public void addAll(RangeSet<T> other) {
        this.backend.addAll(new ConvertingRangeSet<T, T>(other, this.endpointConverter.reverse(), this.rangeConverter.reverse()));
    }

    public void removeAll(RangeSet<T> other) {
        this.backend.removeAll(new ConvertingRangeSet<T, T>(other, this.endpointConverter.reverse(), this.rangeConverter.reverse()));
    }
}

