/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import com.google.common.base.Converter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collection.observable.CollectionChangedEvent;
import org.aksw.commons.collection.observable.CollectionChangedEventImpl;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.commons.collection.observable.StreamOps;
import org.aksw.commons.collections.ConvertingCollection;

public class ObservableConvertingCollection<F, B, C extends ObservableCollection<B>>
extends ConvertingCollection<F, B, C>
implements ObservableCollection<F> {
    protected VetoableChangeSupport vcs = new VetoableChangeSupport(this);
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ObservableConvertingCollection(C backend, Converter<B, F> converter) {
        super(backend, converter);
    }

    protected boolean isDuplicateAwareBackend() {
        return !(this.backend instanceof Set);
    }

    @Override
    public boolean delta(Collection<? extends F> rawAdditions, Collection<?> rawRemovals) {
        Collection convertedRemovals = StreamOps.collect(false, ConvertingCollection.convertRaw(rawRemovals, this.converter.reverse()));
        Collection convertedAdditions = StreamOps.collect(false, ConvertingCollection.convertRaw(rawAdditions, this.converter.reverse()));
        return ((ObservableCollection)this.backend).delta(convertedAdditions, convertedRemovals);
    }

    @Override
    public boolean add(F value) {
        return this.addAll((Collection<? extends F>)Collections.singleton(value));
    }

    @Override
    public boolean addAll(Collection<? extends F> c) {
        boolean isDuplicateAware = this.isDuplicateAwareBackend();
        Stream<Object> itemStream = c.stream().map(arg_0 -> ((Converter)this.converter.reverse()).convert(arg_0));
        Collection items = isDuplicateAware ? (Collection)itemStream.collect(Collectors.toList()) : (Collection)itemStream.collect(Collectors.toSet());
        return ((ObservableCollection)this.backend).addAll(items);
    }

    @Override
    public boolean remove(Object value) {
        return this.removeAll(Collections.singleton(value));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean isDuplicateAware = this.isDuplicateAwareBackend();
        Stream itemStream = ConvertingCollection.convertRaw(c, this.converter.reverse());
        Collection items = isDuplicateAware ? (Collection)itemStream.collect(Collectors.toList()) : (Collection)itemStream.collect(Collectors.toSet());
        return ((ObservableCollection)this.backend).removeAll(items);
    }

    @Override
    public void clear() {
        ((ObservableCollection)this.backend).clear();
    }

    protected static <F, B> Collection<F> convert(Collection<B> set, Converter<B, F> converter) {
        return set == null ? null : ConvertingCollection.createSafe(set, converter);
    }

    public static <F, B, C extends Collection<B>> CollectionChangedEvent<F> convertEvent(Object self, CollectionChangedEvent<B> ev, Converter<B, F> converter) {
        return new CollectionChangedEventImpl<F>(self, ObservableConvertingCollection.convert((Collection)ev.getOldValue(), converter), ObservableConvertingCollection.convert((Collection)ev.getNewValue(), converter), ObservableConvertingCollection.convert(ev.getAdditions(), converter), ObservableConvertingCollection.convert(ev.getDeletions(), converter), ObservableConvertingCollection.convert(ev.getRefreshes(), converter));
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        return ((ObservableCollection)this.getBackend()).addVetoableChangeListener(ev -> {
            CollectionChangedEvent<F> newEv = ObservableConvertingCollection.convertEvent(this, (CollectionChangedEvent)ev, this.converter);
            if (newEv.hasChanges()) {
                listener.vetoableChange(newEv);
            }
        });
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        return ((ObservableCollection)this.getBackend()).addPropertyChangeListener(ev -> {
            CollectionChangedEvent<F> newEv = ObservableConvertingCollection.convertEvent(this, (CollectionChangedEvent)ev, this.converter);
            if (newEv.hasChanges()) {
                listener.propertyChange(newEv);
            }
        });
    }
}

