/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import com.google.common.base.Converter;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Collection;
import org.aksw.commons.collection.observable.ForwardingDeltaCollectionBase;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collections.ConvertingCollection;

public abstract class ObservableCollectionBase<T, C extends Collection<T>>
extends ForwardingDeltaCollectionBase<T, C>
implements ObservableCollection<T> {
    protected VetoableChangeSupport vcs = new VetoableChangeSupport(this);
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ObservableCollectionBase(C backend) {
        super(backend);
    }

    protected static <F, B> Collection<F> convert(Collection<B> set, Converter<B, F> converter) {
        return set == null ? null : ConvertingCollection.createSafe(set, converter);
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs.addVetoableChangeListener(listener);
        return () -> this.vcs.removeVetoableChangeListener(listener);
    }
}

