/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.reversible;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.reversible.ReversibleMap;
import org.aksw.commons.collections.reversible.ReversibleSetMultimap;
import org.aksw.commons.collections.reversible.ReversibleSetMultimapImpl;

public class ReversibleMapImpl<K, V>
extends AbstractMap<K, V>
implements ReversibleMap<K, V> {
    protected ReversibleSetMultimap<V, K> reverse;
    protected Map<K, V> forward;
    protected SetMultimap<V, K> backward;

    public ReversibleMapImpl() {
        this(new HashMap(), (SetMultimap<V, K>)HashMultimap.create());
    }

    public ReversibleMapImpl(Map<K, V> forward, SetMultimap<V, K> backward) {
        this.forward = forward;
        this.backward = backward;
        this.reverse = new ReversibleSetMultimapImpl<K, V>(this, this.backward);
    }

    @Override
    public V put(K key, V value) {
        V result = this.forward.get(key);
        this.backward.remove(result, key);
        this.forward.put(key, value);
        this.backward.put(value, key);
        return result;
    }

    @Override
    public V remove(Object key) {
        V result = this.forward.remove(key);
        this.backward.remove(result, key);
        return result;
    }

    @Override
    public void clear() {
        this.forward.clear();
        this.backward.clear();
    }

    @Override
    public V get(Object key) {
        return this.forward.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backward.containsKey(value);
    }

    @Override
    public ReversibleSetMultimap<V, K> reverse() {
        return this.reverse;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forward.entrySet();
    }
}

