/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.maps;

import com.google.common.base.Converter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.maps.EntryConverterByKey;
import org.aksw.commons.collections.sets.SetFromCollection;

public class MapFromKeyConverter<K, J, V>
extends AbstractMap<K, V> {
    protected Map<J, V> map;
    protected Converter<J, K> converter;

    public MapFromKeyConverter(Map<J, V> map, Converter<J, K> converter) {
        this.map = map;
        this.converter = converter;
    }

    @Override
    public V put(K key, V value) {
        Object j = this.converter.reverse().convert(key);
        V result = this.map.put(j, value);
        return result;
    }

    @Override
    public V get(Object key) {
        V result;
        try {
            Object j = this.converter.reverse().convert(key);
            result = this.map.get(j);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result;
        try {
            Object j = this.converter.reverse().convert(key);
            result = this.map.containsKey(j);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        Object j = this.converter.reverse().convert(key);
        V result = this.map.remove(j);
        return result;
    }

    @Override
    public Set<K> keySet() {
        return new SetFromCollection(new ConvertingCollection<K, J, Set<J>>(this.map.keySet(), this.converter));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetFromCollection<Map.Entry<K, V>>(new ConvertingCollection(this.map.entrySet(), new EntryConverterByKey(this.converter)));
    }
}

