/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.cache;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.cache.Cache;
import org.aksw.commons.collections.cache.IndexBasedIterator;

public class CacheImpl<T>
extends AbstractList<T>
implements Cache<T> {
    protected List<T> data;
    boolean isComplete = false;
    boolean isAbandoned = false;

    public CacheImpl(List<T> data) {
        this.data = data;
    }

    public List<T> getData() {
        return this.data;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.isComplete;
    }

    public synchronized void setComplete(boolean status) {
        this.isComplete = status;
        this.notifyAll();
    }

    @Override
    public synchronized boolean isAbandoned() {
        return this.isAbandoned;
    }

    public synchronized void setAbandoned(boolean isAbandoned) {
        this.isAbandoned = isAbandoned;
        this.notifyAll();
    }

    @Override
    public synchronized boolean add(T e) {
        if (this.isComplete()) {
            throw new RuntimeException("Cannot add data to completed cache");
        }
        boolean result = this.data.add(e);
        this.notifyAll();
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        IndexBasedIterator result = new IndexBasedIterator(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int size() {
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            while (!this.isComplete() && !this.isAbandoned()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.isAbandoned()) {
            throw new RuntimeException("Collection was abandoned");
        }
        int result = this.data.size();
        return result;
    }

    @Override
    public synchronized int getCurrentSize() {
        int result = this.data.size();
        return result;
    }

    @Override
    public void setComplete() {
        this.setComplete(true);
    }

    @Override
    public void setAbandoned() {
        this.setAbandoned(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        int maxIndex;
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            while (index >= (maxIndex = this.getCurrentSize()) && !this.isComplete() && !this.isAbandoned()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (index > maxIndex) {
            throw new IndexOutOfBoundsException(index + " >= " + maxIndex);
        }
        T result = this.data.get(index);
        return result;
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.isComplete()) {
            this.setAbandoned();
        }
    }
}

