/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.base.Converter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.ConvertingList;
import org.aksw.commons.collections.ConvertingSet;
import org.aksw.commons.collections.FilteringCollection;
import org.aksw.commons.collections.FilteringList;
import org.aksw.commons.collections.FilteringSet;
import org.aksw.commons.collections.PredicateFromConverter;
import org.aksw.commons.collections.sets.SetFromCollection;

public class MutableCollectionViews {
    public static <T> Collection<T> filteringCollection(Collection<T> backend, Converter<? super T, ?> converter) {
        Predicate<Object> predicate = PredicateFromConverter.create(converter);
        FilteringCollection<Object, Collection<T>> result = new FilteringCollection<Object, Collection<T>>(backend, predicate);
        return result;
    }

    public static <T> Set<T> filteringSet(Set<T> backend, Converter<? super T, ?> converter) {
        Predicate<Object> predicate = PredicateFromConverter.create(converter);
        FilteringSet result = new FilteringSet(backend, predicate);
        return result;
    }

    public static <T> List<T> filteringList(List<T> backend, Converter<? super T, ?> converter) {
        Predicate<Object> predicate = PredicateFromConverter.create(converter);
        FilteringList<Object, List<T>> result = new FilteringList<Object, List<T>>(backend, predicate);
        return result;
    }

    public static <T, U> Collection<U> convertingCollection(Collection<T> backend, Converter<T, U> converter) {
        ConvertingCollection<U, T, Collection<T>> result = new ConvertingCollection<U, T, Collection<T>>(backend, converter);
        return result;
    }

    public static <T, U> Set<U> convertingSet(Set<T> backend, Converter<T, U> converter, boolean isInjective) {
        Set<Object> result = isInjective ? new ConvertingSet<U, T, Set<T>>(backend, converter) : MutableCollectionViews.wrapAsSet(MutableCollectionViews.convertingCollection(backend, converter));
        return result;
    }

    public static <T, U> List<U> convertingList(List<T> backend, Converter<T, U> converter) {
        ConvertingList<U, T, List<T>> result = new ConvertingList<U, T, List<T>>(backend, converter);
        return result;
    }

    public static <T> Set<T> wrapAsSet(Collection<T> collection) {
        Set<Object> result = collection instanceof Set ? (Set<Object>)collection : new SetFromCollection<T>(collection);
        return result;
    }
}

