/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Iterator;
import java.util.function.Predicate;
import org.aksw.commons.collections.SinglePrefetchIterator;

public class FilteringIterator<T, I extends Iterator<T>>
extends SinglePrefetchIterator<T> {
    protected I baseIt;
    protected Predicate<? super T> predicate;

    public FilteringIterator(I baseIt, Predicate<? super T> predicate) {
        this.baseIt = baseIt;
        this.predicate = predicate;
    }

    @Override
    protected T prefetch() throws Exception {
        while (this.baseIt.hasNext()) {
            Object cand = this.baseIt.next();
            boolean accepted = this.predicate.test(cand);
            if (!accepted) continue;
            return (T)cand;
        }
        return this.finish();
    }

    @Override
    protected void doRemove(T item) {
        this.baseIt.remove();
    }
}

