/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.base.Converter;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.aksw.commons.collections.ConvertingIterator;
import org.aksw.commons.collections.MutableCollectionViews;

public class ConvertingCollection<F, B, C extends Collection<B>>
extends AbstractCollection<F> {
    protected C backend;
    protected Converter<B, F> converter;

    public ConvertingCollection(C backend, Converter<B, F> converter) {
        this.backend = backend;
        this.converter = converter;
    }

    public C getBackend() {
        return this.backend;
    }

    @Override
    public boolean add(F value) {
        Object item = this.converter.reverse().convert(value);
        boolean result = this.backend.add((Object)item);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result;
        try {
            Object item = this.converter.reverse().convert(o);
            result = this.backend.remove(item);
        }
        catch (ClassCastException e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        boolean result;
        try {
            Object item = this.converter.reverse().convert(o);
            result = this.backend.contains(item);
        }
        catch (ClassCastException e) {
            result = false;
        }
        return result;
    }

    @Override
    public Iterator<F> iterator() {
        Iterator baseIt = this.backend.iterator();
        ConvertingIterator result = new ConvertingIterator(baseIt, this.converter);
        return result;
    }

    @Override
    public int size() {
        return this.backend.size();
    }

    public static <F, B, C extends Collection<B>> Collection<F> createSafe(Collection<B> backend, Converter<B, F> converter) {
        Collection<B> safeBackend = MutableCollectionViews.filteringCollection(backend, converter);
        ConvertingCollection<F, B, Collection<B>> result = new ConvertingCollection<F, B, Collection<B>>(safeBackend, converter);
        return result;
    }

    public static <O> Stream<O> convertRaw(Collection<?> c, Converter<?, O> converter) {
        Converter raw = converter;
        Stream<Object> itemStream = c.stream().flatMap(item -> {
            Stream<Object> r;
            try {
                Object b = raw.convert(item);
                r = Stream.of(b);
            }
            catch (ClassCastException e) {
                r = Stream.empty();
            }
            return r;
        }).map(x -> x);
        return itemStream;
    }
}

