/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import org.aksw.commons.accessors.SingleValuedAccessor;
import org.aksw.commons.accessors.SingleValuedAccessorDirect;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.Registration;

public class ObservableValueImpl<T>
implements SingleValuedAccessor<T>,
ObservableValue<T> {
    protected SingleValuedAccessor<T> delegate;
    protected VetoableChangeSupport vcs = new VetoableChangeSupport(this);
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ObservableValueImpl(SingleValuedAccessor<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void set(T value) {
        T before = this.delegate.get();
        try {
            this.vcs.fireVetoableChange(new PropertyChangeEvent(this, "value", before, value));
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        this.delegate.set(value);
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "value", before, value));
    }

    @Override
    public T get() {
        T result = this.delegate.get();
        return result;
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
        return Registration.from(() -> {
            T value = this.get();
            listener.propertyChange(new PropertyChangeEvent(this, "value", value, value));
        }, () -> this.pcs.removePropertyChangeListener(listener));
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs.addVetoableChangeListener(listener);
        return () -> this.vcs.removeVetoableChangeListener(listener);
    }

    public static <T> ObservableValue<T> create(T initialValue) {
        return new ObservableValueImpl<T>(new SingleValuedAccessorDirect<T>(initialValue));
    }

    public String toString() {
        return this.delegate.toString();
    }
}

