/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.accessors;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.commons.accessors.SingleValuedAccessor;
import org.aksw.commons.accessors.SingleValuedAccessorImpl;
import org.aksw.commons.collections.SinglePrefetchIterator;

public class LazyCollection<T, C extends Collection<T>>
extends AbstractCollection<T> {
    protected SingleValuedAccessor<C> accessor;
    protected Supplier<? extends C> ctor;
    protected boolean setNullOnEmpty;
    public static Set<String> test;

    public LazyCollection(SingleValuedAccessor<C> accessor, Supplier<? extends C> ctor, boolean setNullOnEmpty) {
        this.accessor = accessor;
        this.ctor = ctor;
        this.setNullOnEmpty = setNullOnEmpty;
    }

    @Override
    public boolean add(T e) {
        Collection backend = (Collection)this.accessor.get();
        if (backend == null) {
            backend = (Collection)this.ctor.get();
            this.accessor.set(backend);
        }
        boolean result = backend.add(e);
        return result;
    }

    public void checkUnset(Collection<T> backend) {
        if (this.setNullOnEmpty && backend.isEmpty()) {
            this.accessor.set(null);
        }
    }

    @Override
    public boolean remove(Object o) {
        Collection backend = (Collection)this.accessor.get();
        boolean result = backend == null ? false : backend.remove(o);
        this.checkUnset(backend);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        Collection backend = (Collection)this.accessor.get();
        boolean result = backend == null ? false : backend.contains(o);
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        final Collection backend = (Collection)this.accessor.get();
        final Iterator baseIt = ((Collection)Optional.ofNullable(backend).orElse(Collections.emptyList())).iterator();
        return new SinglePrefetchIterator<T>(){

            @Override
            protected T prefetch() throws Exception {
                if (baseIt.hasNext()) {
                    Object b = baseIt.next();
                    return b;
                }
                return this.finish();
            }

            @Override
            public void doRemove(T item) {
                baseIt.remove();
                LazyCollection.this.checkUnset(backend);
            }
        };
    }

    @Override
    public int size() {
        Collection backend = (Collection)this.accessor.get();
        int result = backend == null ? 0 : backend.size();
        return result;
    }

    public static void main(String[] args) {
        SingleValuedAccessorImpl<Set> accessor = new SingleValuedAccessorImpl<Set>(() -> test, val -> {
            test = val;
        });
        LazyCollection tmp = new LazyCollection(accessor, HashSet::new, true);
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Adding item");
        tmp.add("Hello");
        System.out.println("Adding item");
        tmp.add("World");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Removing item");
        tmp.remove("World");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Removing item");
        tmp.remove("Hello");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Adding item");
        tmp.add("World");
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
        System.out.println("Clearing");
        tmp.clear();
        System.out.println("Content: " + String.valueOf(tmp));
        System.out.println("Test: " + String.valueOf(test));
    }
}

