/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.commons.collections.trees.TreeBase;

public class TreeReplace<T>
extends TreeBase<T> {
    protected Tree<T> delegate;
    protected Map<T, T> delegateToReplacement;
    protected Map<T, T> replacementToDelegate;

    public TreeReplace(Tree<T> delegate, Map<T, T> delegateToReplacement, Map<T, T> replacementToDelegate) {
        this.delegate = delegate;
        this.delegateToReplacement = delegateToReplacement;
        this.replacementToDelegate = replacementToDelegate;
    }

    @Override
    public T getRoot() {
        T b = this.delegate.getRoot();
        T result = this.delegateToReplacement.getOrDefault(b, b);
        return result;
    }

    @Override
    public List<T> getChildren(T b) {
        List result;
        if (this.replacementToDelegate.containsKey(b)) {
            result = Collections.emptyList();
        } else {
            Collection<T> bs = this.delegate.getChildren(b);
            result = bs.stream().map(bx -> this.delegateToReplacement.getOrDefault(bx, bx)).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public T getParent(T b) {
        T a = this.replacementToDelegate.getOrDefault(b, b);
        T result = this.delegate.getParent(a);
        return result;
    }

    public String toString() {
        return "TreeReplace [delegate=" + String.valueOf(this.delegate) + ", delegateToReplacement=" + String.valueOf(this.delegateToReplacement) + "]";
    }

    @Override
    public T copy(T node, List<T> children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tree<T> createNew(T root) {
        throw new UnsupportedOperationException();
    }
}

