/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.commons.collections.trees.TreeNode;

public class TreeNodeImpl<T>
implements TreeNode<T> {
    protected Tree<T> tree;
    protected T node;

    public TreeNodeImpl(Tree<T> tree, T node) {
        this.tree = tree;
        this.node = node;
    }

    @Override
    public Tree<T> getTree() {
        return this.tree;
    }

    @Override
    public T getNode() {
        return this.node;
    }

    @Override
    public TreeNode<T> getParent() {
        T tmp = this.tree.getParent(this.node);
        TreeNodeImpl<T> result = new TreeNodeImpl<T>(this.tree, tmp);
        return result;
    }

    @Override
    public Collection<TreeNode<T>> getChildren() {
        Collection<T> tmp = this.tree.getChildren(this.node);
        List<TreeNode<T>> result = tmp.stream().map(child -> new TreeNodeImpl<Object>(this.tree, child)).collect(Collectors.toList());
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.tree == null ? 0 : this.tree.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNodeImpl other = (TreeNodeImpl)obj;
        if (this.node == null ? other.node != null : !this.node.equals(other.node)) {
            return false;
        }
        return !(this.tree == null ? other.tree != null : !this.tree.equals(other.tree));
    }

    public String toString() {
        return "TreeNodeImpl [tree=" + String.valueOf(this.tree) + ", node=" + String.valueOf(this.node) + "]";
    }
}

