/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.reversible.ReversibleMap;
import org.aksw.commons.collections.reversible.ReversibleSetMultimap;
import org.aksw.commons.collections.trees.Tree;

public class TreeDirect<T>
implements Tree<T> {
    protected T root;
    protected ReversibleMap<T, T> nodeToParent;

    public TreeDirect(T root, ReversibleMap<T, T> nodeToParent) {
        this.root = root;
        this.nodeToParent = nodeToParent;
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    @Override
    public Collection<T> getChildren(T node) {
        ReversibleSetMultimap<T, T> parentToChildren = this.nodeToParent.reverse();
        Set result = parentToChildren.get(node);
        return result;
    }

    @Override
    public T getParent(T node) {
        Object result = this.nodeToParent.get(node);
        return (T)result;
    }

    @Override
    public T copy(T node, List<T> children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tree<T> createNew(T root) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long nodeCount() {
        long result = this.nodeToParent.size() + 1;
        return result;
    }
}

