/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.sets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aksw.commons.collections.SinglePrefetchIterator;

public class SetIterator<T>
extends SinglePrefetchIterator<T> {
    protected Collection<T> backend;
    protected Set<T> seen = new HashSet<T>();
    protected Iterator<T> current = null;

    public SetIterator(Collection<T> backend) {
        this.backend = backend;
    }

    @Override
    protected T prefetch() throws Exception {
        if (this.current == null) {
            this.current = this.backend.iterator();
        }
        while (this.current.hasNext()) {
            T result = this.current.next();
            if (this.seen.contains(result)) continue;
            this.seen.add(result);
            return result;
        }
        this.current = null;
        return this.finish();
    }

    @Override
    protected void doRemove(T item) {
        while (this.backend.remove(item)) {
        }
        this.current = null;
    }
}

