/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.frontier;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.aksw.commons.collections.frontier.Frontier;
import org.aksw.commons.collections.frontier.FrontierStatus;

public class FrontierImpl<T>
implements Frontier<T> {
    protected Collection<T> open;
    protected Collection<T> done;

    public FrontierImpl() {
        this(new HashSet(), new HashSet());
    }

    public FrontierImpl(Collection<T> open, Collection<T> done) {
        this.open = open;
        this.done = done;
    }

    @Override
    public void add(T item) {
        boolean isAlreadyDone = this.done.contains(item);
        if (!isAlreadyDone) {
            this.open.add(item);
        }
    }

    @Override
    public T next() {
        Object result;
        Iterator<T> it = this.open.iterator();
        if (it.hasNext()) {
            result = it.next();
            this.done.add(result);
            it.remove();
        } else {
            result = null;
        }
        return (T)result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = this.open.isEmpty();
        return result;
    }

    public static <T> FrontierImpl<T> createIdentityFrontier() {
        FrontierImpl<T> result = new FrontierImpl<T>(Sets.newIdentityHashSet(), Sets.newIdentityHashSet());
        return result;
    }

    @Override
    public FrontierStatus getStatus(Object item) {
        FrontierStatus result;
        boolean isDone = this.done.contains(item);
        boolean isOpen = this.open.contains(item);
        if (isDone) {
            if (isOpen) {
                throw new IllegalStateException();
            }
            result = FrontierStatus.DONE;
        } else {
            result = isOpen ? FrontierStatus.OPEN : FrontierStatus.UNKNOWN;
        }
        return result;
    }

    @Override
    public void setStatus(T item, FrontierStatus status) {
        switch (status) {
            case DONE: {
                this.open.remove(item);
                this.done.add(item);
                break;
            }
            case OPEN: {
                this.done.remove(item);
                this.open.add(item);
                break;
            }
            case UNKNOWN: {
                this.done.remove(item);
                this.open.remove(item);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString() {
        return "FrontierImpl [open=" + String.valueOf(this.open) + ", done=" + String.valueOf(this.done) + "]";
    }

    @Override
    public boolean contains(Object item) {
        boolean result = this.open.contains(item) || this.done.contains(item);
        return result;
    }
}

