/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.AbstractMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class ListIteratorUtils {
    public static <T> Map.Entry<Integer, T> distanceToNext(ListIterator<T> listIterator, Predicate<? super T> predicate) {
        int distance = 0;
        int tmp = 0;
        Object resultItem = null;
        while (listIterator.hasNext()) {
            T item = listIterator.next();
            ++tmp;
            boolean accepted = predicate.test(item);
            if (!accepted) continue;
            resultItem = item;
            distance = tmp;
            break;
        }
        if (distance == 0) {
            ListIteratorUtils.repeatPrevious(listIterator, tmp);
        }
        return new AbstractMap.SimpleEntry<Integer, Object>(distance, resultItem);
    }

    public static <T> Map.Entry<Integer, T> distanceToPrevious(ListIterator<T> listIterator, Predicate<? super T> predicate) {
        int distance = 0;
        int tmp = 0;
        Object resultItem = null;
        while (listIterator.hasPrevious()) {
            T item = listIterator.previous();
            ++tmp;
            boolean accepted = predicate.test(item);
            if (!accepted) continue;
            resultItem = item;
            distance = tmp;
            break;
        }
        if (distance == 0) {
            ListIteratorUtils.repeatPrevious(listIterator, tmp);
        }
        return new AbstractMap.SimpleEntry<Integer, Object>(distance, resultItem);
    }

    public static int repeatPrevious(ListIterator<?> listIterator, int n) {
        int result;
        for (result = 0; result < n && listIterator.hasPrevious(); ++result) {
            Object obj = listIterator.previous();
        }
        return result;
    }

    public static int repeatNext(ListIterator<?> listIterator, int n) {
        int result;
        for (result = 0; result < n && listIterator.hasNext(); ++result) {
            Object obj = listIterator.next();
        }
        return result;
    }

    public static <T> T getItemNext(ListIterator<T> listIterator, int n) {
        T result = null;
        for (int i = 0; i < n; ++i) {
            if (!listIterator.hasNext()) {
                throw new NoSuchElementException("Request to advance " + n + " items failed after " + i + " steps");
            }
            result = listIterator.next();
        }
        return result;
    }

    public static <T> T getItemPrevious(ListIterator<T> listIterator, int n) {
        T result = null;
        for (int i = 0; i < n; ++i) {
            if (!listIterator.hasPrevious()) {
                throw new NoSuchElementException("Request to advance " + n + " items failed after " + i + " steps");
            }
            result = listIterator.previous();
        }
        return result;
    }
}

