/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.aksw.commons.collections.IteratorIterable;

public class IteratorUtils {
    public static <T> Iterable<T> makeIterable(Iterator<T> iterator) {
        return new IteratorIterable<T>(iterator);
    }

    public static <T> T expectOneItem(Iterator<T> iterator) {
        T result = null;
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Exactly one item expected in stream; got none");
        }
        result = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Exactly one item expected in stream; got multiple");
        }
        return result;
    }

    public static <T> T expectZeroOrOneItems(Iterator<T> iterator) {
        T result = !iterator.hasNext() ? null : (T)IteratorUtils.expectOneItem(iterator);
        return result;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator, final long limitSize) {
        Objects.requireNonNull(iterator);
        return new Iterator<T>(){
            protected long count;

            @Override
            public boolean hasNext() {
                return this.count < limitSize && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

