/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.rangeset;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import org.aksw.commons.collection.rangeset.AsRangesBase;
import org.aksw.commons.collection.rangeset.RangeSetComplement;
import org.aksw.commons.collection.rangeset.RangeSetUtils;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.util.range.RangeUtils;

public class RangeSetUnion<T extends Comparable<T>>
implements RangeSet<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected RangeSet<T> first;
    protected RangeSet<T> second;
    protected transient RangeSet<T> complement = null;
    protected transient Set<Range<T>> asRanges = null;
    protected transient Set<Range<T>> asDescendingSetOfRanges = null;

    public RangeSetUnion(RangeSet<T> first, RangeSet<T> second) {
        this.first = first;
        this.second = second;
    }

    public static <T extends Comparable<T>> RangeSetUnion<T> create(RangeSet<T> first, RangeSet<T> second) {
        return new RangeSetUnion<T>(first, second);
    }

    public RangeSet<T> getFirst() {
        return this.first;
    }

    public RangeSet<T> getSecond() {
        return this.second;
    }

    public boolean contains(T value) {
        boolean result = this.first.contains(value) || this.second.contains(value);
        return result;
    }

    public Range<T> rangeContaining(T value) {
        Range result = RangeSetUtils.getRangesBeforeAndAfter(this, value).stream().filter(range -> range.contains(value)).findFirst().orElse(null);
        return result;
    }

    public boolean intersects(Range<T> otherRange) {
        boolean result = this.first.intersects(otherRange) || this.second.intersects(otherRange);
        return result;
    }

    public boolean encloses(Range<T> otherRange) {
        Range onlyRange;
        Comparable endpoint;
        Comparable comparable = otherRange.hasLowerBound() ? otherRange.lowerEndpoint() : (endpoint = otherRange.hasUpperBound() ? otherRange.upperEndpoint() : null);
        boolean result = endpoint == null ? (onlyRange = (Range)Iterables.getFirst(this.asRanges(), null)) != null && onlyRange.encloses(otherRange) : RangeSetUtils.getRangesBeforeAndAfter(this, endpoint).stream().anyMatch(range -> range.encloses(otherRange));
        return result;
    }

    public boolean enclosesAll(RangeSet<T> other) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        boolean result = this.first.isEmpty() && this.second.isEmpty();
        return result;
    }

    public Range<T> span() {
        Range result = this.first.span().span(this.second.span());
        return result;
    }

    public Set<Range<T>> asRanges() {
        if (this.asRanges == null) {
            this.asRanges = new AsRangesBase(SetUtils.newForwardingSet(() -> this.first.asRanges()), SetUtils.newForwardingSet(() -> this.second.asRanges()), RangeUtils::compareToLowerBound);
        }
        return this.asRanges;
    }

    public Set<Range<T>> asDescendingSetOfRanges() {
        if (this.asDescendingSetOfRanges == null) {
            Comparator cmp = RangeUtils::compareToUpperBound;
            cmp = cmp.reversed();
            this.asDescendingSetOfRanges = new AsRangesBase(SetUtils.newForwardingSet(() -> this.first.asDescendingSetOfRanges()), SetUtils.newForwardingSet(() -> this.second.asDescendingSetOfRanges()), cmp);
        }
        return this.asDescendingSetOfRanges;
    }

    public RangeSet<T> complement() {
        if (this.complement == null) {
            this.complement = new RangeSetComplement(this, Range.all());
        }
        return this.complement;
    }

    public RangeSet<T> subRangeSet(Range<T> view) {
        return new RangeSetUnion<T>(this.first.subRangeSet(view), this.second.subRangeSet(view));
    }

    public void add(Range<T> range) {
        this.first.add(range);
    }

    public void remove(Range<T> range) {
        this.first.remove(range);
    }

    public void clear() {
        this.first.clear();
    }

    public void addAll(RangeSet<T> other) {
        this.first.addAll(other);
    }

    public void removeAll(RangeSet<T> other) {
        this.first.removeAll(other);
    }

    public String toString() {
        return this.asRanges().toString();
    }
}

