/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Objects;
import java.util.Set;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.Registration;

public interface ObservableSet<T>
extends ObservableCollection<T>,
Set<T> {
    default public ObservableValue<Boolean> fieldForPresence(final T item) {
        return new ObservableValue<Boolean>(){

            @Override
            public Boolean get() {
                return ObservableSet.this.contains(item);
            }

            @Override
            public void set(Boolean onOrOff) {
                if (!Boolean.TRUE.equals(onOrOff)) {
                    ObservableSet.this.remove(item);
                } else {
                    ObservableSet.this.add(item);
                }
            }

            @Override
            public Registration addPropertyChangeListener(PropertyChangeListener listener) {
                return ObservableSet.this.addPropertyChangeListener(ev -> {
                    Boolean oldValue = ((Set)ev.getOldValue()).contains(item);
                    Boolean newValue = ((Set)ev.getNewValue()).contains(item);
                    if (oldValue != null && newValue != null && !Objects.equals(oldValue, newValue)) {
                        listener.propertyChange(new PropertyChangeEvent(this, "value", oldValue, newValue));
                    }
                });
            }

            @Override
            public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

