/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.aksw.commons.collection.observable.CollectionChangedEvent;
import org.aksw.commons.collection.observable.CollectionChangedEventImpl;
import org.aksw.commons.collection.observable.ObservableMap;
import org.aksw.commons.collection.observable.ObservableSet;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.commons.collections.MapUtils;
import org.aksw.commons.collections.SinglePrefetchIterator;

public class ObservableMapImpl<K, V>
extends AbstractMap<K, V>
implements ObservableMap<K, V> {
    protected Map<K, V> delegate;
    protected VetoableChangeSupport vcs = new VetoableChangeSupport(this);
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ObservableMapImpl(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    public static <K, V> ObservableMap<K, V> decorate(Map<K, V> delegate) {
        return new ObservableMapImpl<K, V>(delegate);
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs.addVetoableChangeListener(listener);
        return () -> this.vcs.removeVetoableChangeListener(listener);
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
        return Registration.from(() -> listener.propertyChange(new CollectionChangedEventImpl(this, this, this, Collections.emptySet(), Collections.emptySet(), Collections.emptySet())), () -> this.pcs.removePropertyChangeListener(listener));
    }

    @Override
    public V put(K key, V value) {
        Map<K, V> newItem = Collections.singletonMap(key, value);
        Map removedItem = Collections.emptyMap();
        if (this.delegate.containsKey(key)) {
            removedItem = Collections.singletonMap(key, this.delegate.get(key));
        }
        ObservableMapImpl oldValue = this;
        Map<K, V> newValue = MapUtils.union(oldValue, newItem);
        try {
            this.vcs.fireVetoableChange(new CollectionChangedEventImpl(this, oldValue, newValue, newItem.entrySet(), removedItem.entrySet(), Collections.emptySet()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        V result = this.delegate.put(key, value);
        Map oldValue2 = removedItem.isEmpty() ? Maps.filterKeys((Map)this, k -> !Objects.equals(k, key)) : MapUtils.union(this, removedItem);
        ObservableMapImpl newValue2 = this;
        this.pcs.firePropertyChange(new CollectionChangedEventImpl(this, oldValue2, newValue2, newItem.entrySet(), removedItem.entrySet(), Collections.emptySet()));
        return result;
    }

    @Override
    public V remove(Object key) {
        V result = null;
        if (this.delegate.containsKey(key)) {
            V v = this.delegate.get(key);
            Object k = key;
            this.doRemoveEntry(k, v);
        }
        return result;
    }

    protected V doRemoveEntry(K key, V v) {
        Map<K, V> removedItem = Collections.singletonMap(key, v);
        ObservableMapImpl oldValue = this;
        Map newValue = Maps.filterKeys(this.delegate, k -> !Objects.equals(k, key));
        try {
            this.vcs.fireVetoableChange(new CollectionChangedEventImpl<Map.Entry<K, V>>(this, oldValue, newValue, Collections.emptySet(), removedItem.entrySet(), Collections.emptySet()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        V result = this.delegate.remove(key);
        Map<K, V> oldValue2 = MapUtils.union(this, removedItem);
        ObservableMapImpl newValue2 = this;
        this.pcs.firePropertyChange(new CollectionChangedEventImpl<Map.Entry<K, V>>(this, oldValue2, newValue2, Collections.emptySet(), removedItem.entrySet(), Collections.emptySet()));
        return result;
    }

    protected void notifyClear() {
        this.pcs.firePropertyChange(new CollectionChangedEventImpl<Map.Entry<K, V>>(this, this, Collections.emptyMap(), Collections.emptySet(), this.entrySet(), Collections.emptySet()));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void clear() {
        this.notifyClear();
        this.delegate.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public void clear() {
                ObservableMapImpl.this.notifyClear();
                ObservableMapImpl.this.delegate.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                boolean result;
                boolean bl = result = !this.contains(e);
                if (!result) {
                    ObservableMapImpl.this.put(e.getKey(), e.getValue());
                }
                return result;
            }

            @Override
            public boolean remove(Object o) {
                boolean result = false;
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    result = ObservableMapImpl.this.remove(e.getKey(), e.getValue());
                }
                return result;
            }

            @Override
            public boolean contains(Object o) {
                boolean result = false;
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    Object k = e.getKey();
                    result = ObservableMapImpl.this.containsKey(k) && Objects.equals(e.getValue(), ObservableMapImpl.this.get(k));
                }
                return result;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator baseIt = ObservableMapImpl.this.delegate.entrySet().iterator();
                return new SinglePrefetchIterator<Map.Entry<K, V>>(){

                    @Override
                    protected Map.Entry<K, V> prefetch() throws Exception {
                        return baseIt.hasNext() ? (Map.Entry)baseIt.next() : (Map.Entry)this.finish();
                    }

                    @Override
                    protected void doRemove(Map.Entry<K, V> item) {
                        ObservableMapImpl.this.doRemoveEntry(item.getKey(), item.getValue());
                        baseIt.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ObservableMapImpl.this.delegate.size();
            }
        };
    }

    @Override
    public ObservableSet<K> keySet() {
        return new ObservableKeySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    public class ObservableKeySet
    extends ForwardingSet<K>
    implements ObservableSet<K> {
        protected Set<K> delegate() {
            return ObservableMapImpl.this.delegate.keySet();
        }

        public CollectionChangedEvent<K> convertEvent(PropertyChangeEvent event) {
            CollectionChangedEvent ev = (CollectionChangedEvent)event;
            Set oldKeySet = ((Map)ev.getOldValue()).keySet();
            Set newKeySet = ((Map)ev.getNewValue()).keySet();
            CollectionChangedEventImpl result = new CollectionChangedEventImpl(this, oldKeySet, newKeySet, Sets.difference(newKeySet, oldKeySet), Sets.difference(oldKeySet, newKeySet), Collections.emptySet());
            return result;
        }

        @Override
        public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
            return ObservableMapImpl.this.addVetoableChangeListener(event -> {
                CollectionChangedEvent newEv = this.convertEvent(event);
                if (newEv.hasChanges()) {
                    listener.vetoableChange(newEv);
                }
            });
        }

        @Override
        public Registration addPropertyChangeListener(PropertyChangeListener listener) {
            return ObservableMapImpl.this.addPropertyChangeListener(event -> {
                CollectionChangedEvent newEv = this.convertEvent(event);
                if (newEv.hasChanges()) {
                    listener.propertyChange(newEv);
                }
            });
        }

        @Override
        public boolean delta(Collection<? extends K> additions, Collection<?> removals) {
            throw new UnsupportedOperationException();
        }
    }
}

