/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import com.google.common.collect.Collections2;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.commons.collection.observable.CollectionChangedEvent;
import org.aksw.commons.collection.observable.CollectionChangedEventImpl;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.commons.collection.observable.StreamOps;
import org.aksw.commons.collections.FilteringCollection;

public class FilteredObservableCollection<T>
extends FilteringCollection<T, ObservableCollection<T>>
implements ObservableCollection<T> {
    public FilteredObservableCollection(ObservableCollection<T> backend, Predicate<? super T> predicate) {
        super(backend, predicate);
    }

    @Override
    public boolean delta(Collection<? extends T> rawAdditions, Collection<?> rawRemovals) {
        Collection filteredRemovals = StreamOps.filter(rawRemovals.stream(), this.predicate).collect(Collectors.toSet());
        Collection filteredAdditions = rawAdditions.stream().filter(this.predicate).collect(Collectors.toSet());
        return ((ObservableCollection)this.backend).delta(filteredAdditions, filteredRemovals);
    }

    public static <T> CollectionChangedEvent<T> filter(Object self, CollectionChangedEvent<T> event, Predicate<? super T> predicate) {
        return new CollectionChangedEventImpl(self, Collections2.filter((Collection)((Collection)event.getOldValue()), predicate::test), Collections2.filter((Collection)((Collection)event.getNewValue()), predicate::test), Collections2.filter(event.getAdditions(), predicate::test), Collections2.filter(event.getDeletions(), predicate::test), Collections2.filter(event.getRefreshes(), predicate::test));
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        return ((ObservableCollection)this.getBackend()).addVetoableChangeListener(event -> {
            CollectionChangedEvent<T> newEv = FilteredObservableCollection.filter(this, (CollectionChangedEvent)event, this.predicate);
            if (newEv.hasChanges()) {
                listener.vetoableChange(newEv);
            }
        });
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        return ((ObservableCollection)this.getBackend()).addPropertyChangeListener(event -> {
            CollectionChangedEvent raw = (CollectionChangedEvent)event;
            CollectionChangedEvent<T> newEv = FilteredObservableCollection.filter(this, raw, this.predicate);
            if (!raw.hasChanges() || newEv.hasChanges()) {
                listener.propertyChange(newEv);
            }
        });
    }
}

