/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.cache.async;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefFuture;
import org.aksw.commons.util.ref.RefFutureImpl;
import org.aksw.commons.util.ref.RefImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRefCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRefCache.class);
    protected AsyncLoadingCache<K, V> master;
    protected Map<K, RefFuture<V>> slave;

    public static <K, V> AsyncRefCache<K, V> create(Caffeine<Object, Object> master, Function<K, V> cacheLoader, RemovalListener<K, V> removalListener) {
        return new AsyncRefCache<K, V>(master, cacheLoader, removalListener);
    }

    public AsyncRefCache(Caffeine<Object, Object> cacheBuilder, Function<K, V> cacheLoader, RemovalListener<K, V> removalListener) {
        this.master = cacheBuilder.evictionListener((key, value, cause) -> {
            Map<K, RefFuture<V>> map = this.slave;
            synchronized (map) {
                logger.debug("Evicting " + String.valueOf(key));
                removalListener.onRemoval(key, value, cause);
                this.slave.remove(key);
            }
        }).buildAsync(key -> {
            logger.debug("Loading: " + String.valueOf(key));
            Object value = cacheLoader.apply(key);
            return value;
        });
        this.slave = new ConcurrentHashMap<K, RefFuture<V>>();
    }

    public CompletableFuture<V> getAsCompletableFuture(K key) {
        final RefFuture refFuture = this.getAsRefFuture(key);
        CompletableFuture result = new CompletableFuture<V>(this){
            final /* synthetic */ AsyncRefCache this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (refFuture.isAlive()) {
                    refFuture.close();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        ((CompletableFuture)refFuture.get()).whenComplete((v, t) -> {
            if (t == null) {
                result.complete(v);
            } else {
                result.completeExceptionally((Throwable)t);
            }
            if (refFuture.isAlive()) {
                refFuture.close();
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, RefFuture<V> value) {
        Map<K, RefFuture<V>> map = this.slave;
        synchronized (map) {
            if (!value.isAlive()) {
                throw new RuntimeException("Cannot put a dead reference");
            }
            this.master.put(key, (CompletableFuture)value.get());
            this.slave.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefFuture<V> getAsRefFuture(K key) {
        RefFuture result;
        Map<K, RefFuture<V>> map = this.slave;
        synchronized (map) {
            boolean[] isNewRootRef = new boolean[]{false};
            RefFuture rootRef = this.slave.computeIfAbsent(key, k -> {
                CompletableFuture future = this.master.get(key);
                isNewRootRef[0] = true;
                Ref tmp = RefImpl.create((Object)future, this.slave, () -> {
                    RefFutureImpl.cancelFutureOrCloseValue((CompletableFuture)future, null);
                    this.slave.remove(key);
                });
                RefFuture r = RefFutureImpl.wrap((Ref)tmp);
                return r;
            });
            result = rootRef.acquire();
            if (isNewRootRef[0]) {
                rootRef.close();
            }
        }
        return result;
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        AsyncRefCache<String, String> cache = AsyncRefCache.create((Caffeine<Object, Object>)Caffeine.newBuilder().executor((Executor)ForkJoinPool.commonPool()).maximumSize(1000L), key -> {
            String r;
            try {
                Thread.sleep(1000L);
                r = "value for " + key;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                r = null;
            }
            return r;
        }, (k, v, cause) -> {});
        CompletableFuture<String> future = cache.getAsCompletableFuture("test");
        future.cancel(true);
        List<CompletableFuture> futures = IntStream.range(0, 10).mapToObj(i -> cache.getAsCompletableFuture("test")).collect(Collectors.toList());
        futures.forEach(cf -> cf.cancel(true));
        System.out.println(cache.getAsCompletableFuture("test").get());
    }

    public RefFuture<V> getIfPresent(K key) {
        RefFuture<V> result = this.slave.get(key);
        return result;
    }

    public void invalidateAll() {
        this.master.synchronous().invalidateAll();
    }
}

