/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.cache.async;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.accessors.SingleValuedAccessor;
import org.aksw.commons.accessors.SingleValuedAccessorDirect;
import org.aksw.commons.cache.async.AsyncClaimingCache;
import org.aksw.commons.util.closeable.Disposable;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefFuture;
import org.aksw.commons.util.ref.RefFutureImpl;
import org.aksw.commons.util.ref.RefImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClaimingCache3Impl<K, V>
implements AsyncClaimingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncClaimingCache3Impl.class);
    protected Map<K, RefFuture<V>> level1;
    protected Cache<K, SingleValuedAccessor<CompletableFuture<V>>> level2;
    protected AsyncLoadingCache<K, V> level3;
    protected RemovalListener<K, V> level2RemovalListener;

    public static <K, V> AsyncClaimingCache3Impl<K, V> create(Duration syncDelayDuration, Caffeine<Object, Object> level3Master, Function<K, V> level3CacheLoader, RemovalListener<K, V> level3RemovalListener, RemovalListener<K, V> level2RemovalListener) {
        return new AsyncClaimingCache3Impl<K, V>(level3Master, level3CacheLoader, level3RemovalListener, level2RemovalListener, syncDelayDuration);
    }

    public AsyncClaimingCache3Impl(Caffeine<Object, Object> level3Master, Function<K, V> level3CacheLoader, RemovalListener<K, V> level3RemovalListener, RemovalListener<K, V> level2RemovalListener, Duration syncDelayDuration) {
        this.level2RemovalListener = level2RemovalListener;
        this.level2 = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterWrite(syncDelayDuration).evictionListener((key, holder, removalCause) -> {
            CompletableFuture future = (CompletableFuture)holder.get();
            if (future != null) {
                logger.trace("Level2 eviction action: Syncing & passing to level 3: " + String.valueOf(key));
                if (future.isDone()) {
                    Object value;
                    try {
                        value = future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    level2RemovalListener.onRemoval(key, value, removalCause);
                    this.level3.put(key, future);
                }
            } else {
                logger.trace("Level2 eviction action: Reference was null - assuming re-claimed to level 1");
            }
        }).build();
        this.level3 = level3Master.evictionListener((key, value, removalCause) -> {
            Map<K, RefFuture<V>> map = this.level1;
            synchronized (map) {
                boolean isKeyPresentInLevel1Or2;
                SingleValuedAccessor holder = (SingleValuedAccessor)this.level2.getIfPresent(key);
                boolean bl = isKeyPresentInLevel1Or2 = this.level1.containsKey(key) || holder != null && holder.get() != null;
                if (!isKeyPresentInLevel1Or2) {
                    logger.debug("Complete eviction of " + String.valueOf(key) + " is - no longer present in any other level");
                    level3RemovalListener.onRemoval(key, value, removalCause);
                }
            }
        }).buildAsync(key -> {
            logger.debug("Loading: " + String.valueOf(key));
            Object value = level3CacheLoader.apply(key);
            return value;
        });
        this.level1 = new ConcurrentHashMap<K, RefFuture<V>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(K key) {
        Map<K, RefFuture<V>> map = this.level1;
        synchronized (map) {
            RefFuture<V> ref = this.level1.get(key);
            if (ref != null) {
                CompletableFuture future = (CompletableFuture)ref.get();
                if (((CompletableFuture)ref.get()).isDone()) {
                    Object value;
                    try {
                        value = future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException();
                    }
                    this.level2RemovalListener.onRemoval(key, value, RemovalCause.EXPLICIT);
                }
            } else {
                this.level2.invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncAll() {
        Map<K, RefFuture<V>> map = this.level1;
        synchronized (map) {
            this.level2.invalidateAll();
            for (Map.Entry<K, RefFuture<V>> entry : this.level1.entrySet()) {
                K key = entry.getKey();
                RefFuture<V> ref = entry.getValue();
                RefFuture tmp = ref.acquire();
                try {
                    Object value;
                    CompletableFuture future = (CompletableFuture)tmp.get();
                    if (!future.isDone()) continue;
                    try {
                        value = future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException();
                    }
                    this.level2RemovalListener.onRemoval(key, value, RemovalCause.EXPLICIT);
                }
                finally {
                    if (tmp == null) continue;
                    tmp.close();
                }
            }
        }
    }

    public RefFuture<V> claimUnsafe(K key) {
        try {
            return this.claim(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefFuture<V> claim(K key) {
        RefFuture result;
        Map<K, RefFuture<V>> map = this.level1;
        synchronized (map) {
            boolean[] isFreshSecondaryRef = new boolean[]{false};
            RefFuture secondaryRef = this.level1.computeIfAbsent(key, k -> {
                CompletableFuture tmpRefFuture;
                SingleValuedAccessor holder = (SingleValuedAccessor)this.level2.getIfPresent(key);
                CompletableFuture completableFuture = tmpRefFuture = holder == null ? null : (CompletableFuture)holder.get();
                if (tmpRefFuture != null) {
                    logger.trace("Claiming item [" + String.valueOf(key) + "] from level2");
                    holder.set(null);
                    this.level2.invalidate(key);
                } else {
                    logger.trace("Claiming item [" + String.valueOf(key) + "] from level3");
                    tmpRefFuture = this.level3.get(key);
                }
                CompletableFuture refFuture = tmpRefFuture;
                Ref freshSecondaryRef = RefImpl.create((Object)tmpRefFuture, this.level1, () -> {
                    RefFutureImpl.cancelFutureOrCloseValue((CompletableFuture)refFuture, null);
                    this.level1.remove(key);
                    logger.trace("Item [" + String.valueOf(key) + "] was unclaimed. Transferring to level2.");
                    this.level2.put(key, (Object)new SingleValuedAccessorDirect((Object)refFuture));
                });
                isFreshSecondaryRef[0] = true;
                return RefFutureImpl.wrap((Ref)freshSecondaryRef);
            });
            result = secondaryRef.acquire();
            if (isFreshSecondaryRef[0]) {
                secondaryRef.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefFuture<V> claimIfPresent(K key) {
        RefFuture<V> result = null;
        Map<K, RefFuture<V>> map = this.level1;
        synchronized (map) {
            if (this.level1.containsKey(key) || this.level2.getIfPresent(key) != null || this.level3.getIfPresent(key) != null) {
                result = this.claimUnsafe(key);
            }
        }
        return result;
    }

    @Override
    public void invalidateAll() {
        this.level3.synchronous().invalidateAll();
    }

    public static <V> Ref<V> hideInnerRef(Ref<? extends Ref<V>> refToRef, Object synchronizer) {
        Ref tmpRef = refToRef.acquire();
        return RefImpl.create((Object)((Ref)tmpRef.get()).get(), (Object)synchronizer, () -> ((Ref)tmpRef).close());
    }

    public Ref<V> hideInnerRef(Ref<? extends Ref<V>> refToRef) {
        return AsyncClaimingCache3Impl.hideInnerRef(refToRef, this.level1);
    }

    @Override
    public Disposable addEvictionGuard(Predicate<? super K> predicate) {
        throw new UnsupportedOperationException();
    }
}

