/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.cache.plain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;

public class RangeCache<C extends Comparable<C>, V> {
    protected Cache<Range<C>, V> cache;
    protected RangeSet<C> cacheKeys;
    protected RangeMap<C, Ref<V>> claimed;

    public RangeCache(CacheBuilder<Range<C>, V> cacheBuilder) {
        cacheBuilder.removalListener(ev -> {
            RangeCache rangeCache = this;
            synchronized (rangeCache) {
                this.cacheKeys.remove((Range)ev.getKey());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Range<C> key, V value) {
        RangeCache rangeCache = this;
        synchronized (rangeCache) {
            if (this.cacheKeys.intersects(key)) {
                throw new IllegalArgumentException(String.format("Provided range %s overlaps with an existing entry", key));
            }
            this.cacheKeys.add(key);
            this.cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeMap<C, Ref<V>> claimAll(Range<C> requestRange) {
        TreeRangeMap result = TreeRangeMap.create();
        RangeCache rangeCache = this;
        synchronized (rangeCache) {
            RangeMap tmp = this.claimed.subRangeMap(requestRange);
            for (Map.Entry entry : tmp.asMapOfRanges().entrySet()) {
                result.put((Range)entry.getKey(), (Object)((Ref)entry.getValue()).acquire());
            }
            Set resultKeySet = result.asMapOfRanges().keySet();
            RangeSet keys = this.cacheKeys.subRangeSet(requestRange);
            for (Range key : keys.asRanges()) {
                Object value;
                if (resultKeySet.contains(key) || (value = this.cache.getIfPresent((Object)key)) == null) continue;
                Ref rootRef = RefImpl.create((Object)value, (Object)this, () -> {
                    this.cache.put((Object)key, value);
                    this.claimed.remove(key);
                });
                result.put(key, (Object)rootRef.acquire());
                rootRef.close();
                this.claimed.put(key, (Object)rootRef);
            }
        }
        return result;
    }
}

