/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.cache.plain;

import org.aksw.commons.cache.async.AsyncClaimingCache;
import org.aksw.commons.cache.plain.ClaimingCache;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefFuture;
import org.aksw.commons.util.ref.RefImpl;

public class ClaimingCacheOverAsync<K, V>
implements ClaimingCache<K, V> {
    protected AsyncClaimingCache<K, V> delegate;

    public ClaimingCacheOverAsync(AsyncClaimingCache<K, V> delegate) {
        this.delegate = delegate;
    }

    public static <K, V> ClaimingCache<K, V> wrap(AsyncClaimingCache<K, V> delegate) {
        return new ClaimingCacheOverAsync<K, V>(delegate);
    }

    @Override
    public Ref<V> claim(K key) {
        RefFuture<V> refFuture = this.delegate.claim(key);
        return this.await(refFuture);
    }

    protected Ref<V> await(RefFuture<V> refFuture) {
        Object value = refFuture.await();
        Ref result = RefImpl.create((Object)value, (Object)refFuture.getSynchronizer(), () -> refFuture.close());
        return result;
    }

    @Override
    public Ref<V> claimIfPresent(K key) {
        RefFuture<V> refFuture = this.delegate.claimIfPresent(key);
        Ref<V> result = refFuture == null ? null : this.await(refFuture);
        return result;
    }

    @Override
    public void invalidateAll() {
        this.delegate.invalidateAll();
    }
}

