/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.cache.async;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.aksw.commons.accessors.SingleValuedAccessor;
import org.aksw.commons.accessors.SingleValuedAccessorDirect;
import org.aksw.commons.cache.async.AsyncClaimingCache;
import org.aksw.commons.util.closeable.Disposable;
import org.aksw.commons.util.lock.LockUtils;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefFuture;
import org.aksw.commons.util.ref.RefFutureImpl;
import org.aksw.commons.util.ref.RefImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClaimingCacheImpl<K, V>
implements AsyncClaimingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncClaimingCacheImpl.class);
    protected Map<K, RefFuture<V>> level1;
    protected AsyncLoadingCache<K, V> level2;
    protected Map<K, V> level3;
    protected BiConsumer<K, RefFuture<V>> claimListener;
    protected BiConsumer<K, RefFuture<V>> unclaimListener;
    protected ReentrantReadWriteLock invalidationLock = new ReentrantReadWriteLock();
    protected LinkedList<Predicate<? super K>> evictionGuards;
    protected RemovalListener<K, V> evictionListener;
    protected Map<K, Latch> keyToSynchronizer = new ConcurrentHashMap<K, Latch>();

    public AsyncClaimingCacheImpl(Map<K, RefFuture<V>> level1, AsyncLoadingCache<K, V> level2, Map<K, V> level3, LinkedList<Predicate<? super K>> evictionGuards, BiConsumer<K, RefFuture<V>> claimListener, BiConsumer<K, RefFuture<V>> unclaimListener, RemovalListener<K, V> evictionListener) {
        this.level1 = level1;
        this.level2 = level2;
        this.level3 = level3;
        this.evictionGuards = evictionGuards;
        this.claimListener = claimListener;
        this.unclaimListener = unclaimListener;
        this.evictionListener = evictionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Disposable addEvictionGuard(Predicate<? super K> predicate) {
        ListIterator<Predicate<K>> removalPointer;
        LinkedList<Predicate<? super K>> linkedList = this.evictionGuards;
        synchronized (linkedList) {
            this.evictionGuards.add(predicate);
            removalPointer = this.evictionGuards.listIterator(this.evictionGuards.size());
            removalPointer.previous();
        }
        return () -> {
            LinkedList<Predicate<? super K>> linkedList = this.evictionGuards;
            synchronized (linkedList) {
                removalPointer.remove();
                this.runLevel3Eviction();
            }
        };
    }

    protected void runLevel3Eviction() {
        for (Map.Entry<K, V> e : this.level3.entrySet()) {
            Object k = e.getKey();
            V v = e.getValue();
            boolean isGuarded = this.evictionGuards.stream().anyMatch(p -> p.test(k));
            if (isGuarded) continue;
            this.evictionListener.onRemoval(k, v, RemovalCause.COLLECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefFuture<V> claim(K key) {
        RefFuture result;
        Latch synchronizer;
        Latch latch = synchronizer = this.keyToSynchronizer.compute(key, (k, before) -> before == null ? new Latch() : before.inc());
        synchronized (latch) {
            this.keyToSynchronizer.compute(key, (k, before) -> before.dec());
            boolean[] isFreshSecondaryRef = new boolean[]{false};
            RefFuture secondaryRef = (RefFuture)LockUtils.runWithLock((Lock)this.invalidationLock.readLock(), () -> this.level1.computeIfAbsent(key, k -> {
                if (logger.isTraceEnabled()) {
                    logger.trace("Claiming item [{}] from level2", key);
                }
                CompletableFuture future = this.level2.get(key);
                this.level2.asMap().remove(key);
                SingleValuedAccessorDirect holder = new SingleValuedAccessorDirect(null);
                Ref freshSecondaryRef = RefImpl.create((Object)future, (Object)synchronizer, () -> this.lambda$claim$5((SingleValuedAccessor)holder, key, future));
                isFreshSecondaryRef[0] = true;
                RefFuture r = RefFutureImpl.wrap((Ref)freshSecondaryRef);
                holder.set((Object)r);
                return r;
            }));
            result = secondaryRef.acquire();
            if (this.claimListener != null) {
                this.claimListener.accept(key, result);
            }
            if (isFreshSecondaryRef[0]) {
                secondaryRef.close();
            }
        }
        return result;
    }

    public static <K, V> Builder<K, V> newBuilder(Caffeine<Object, Object> caffeine) {
        Builder result = new Builder();
        result.setCaffeine(caffeine);
        return result;
    }

    @Override
    public RefFuture<V> claimIfPresent(K key) {
        RefFuture<V> result = this.level1.containsKey(key) || this.level2.asMap().containsKey(key) ? this.claim(key) : null;
        return result;
    }

    @Override
    public void invalidateAll() {
        LockUtils.runWithLock((Lock)this.invalidationLock.writeLock(), () -> this.level2.synchronous().invalidateAll());
    }

    private /* synthetic */ void lambda$claim$5(SingleValuedAccessor holder, Object key, CompletableFuture future) throws Exception {
        RefFuture v = (RefFuture)holder.get();
        if (this.unclaimListener != null) {
            this.unclaimListener.accept(key, v);
        }
        RefFutureImpl.cancelFutureOrCloseValue((CompletableFuture)future, null);
        this.level1.remove(key);
        if (logger.isTraceEnabled()) {
            logger.trace("Item [{}] was unclaimed. Transferring to level2.", key);
        }
        this.level2.put(key, future);
        this.keyToSynchronizer.compute(key, (kk, before) -> before.get() == 0 ? null : before);
    }

    private static class Latch {
        volatile int numWaitingThreads = 1;

        private Latch() {
        }

        Latch inc() {
            ++this.numWaitingThreads;
            return this;
        }

        Latch dec() {
            --this.numWaitingThreads;
            return this;
        }

        int get() {
            return this.numWaitingThreads;
        }

        public String toString() {
            return "Latch " + System.identityHashCode(this) + " has " + this.numWaitingThreads + " threads waiting";
        }
    }

    public static class Builder<K, V> {
        protected Caffeine<Object, Object> caffeine;
        protected CacheLoader<K, V> cacheLoader;
        protected BiConsumer<K, RefFuture<V>> claimListener;
        protected BiConsumer<K, RefFuture<V>> unclaimListener;
        protected RemovalListener<K, V> userEvictionListener;

        Builder<K, V> setCaffeine(Caffeine<Object, Object> caffeine) {
            this.caffeine = caffeine;
            return this;
        }

        public Builder<K, V> setClaimListener(BiConsumer<K, RefFuture<V>> claimListener) {
            this.claimListener = claimListener;
            return this;
        }

        public Builder<K, V> setUnclaimListener(BiConsumer<K, RefFuture<V>> unclaimListener) {
            this.unclaimListener = unclaimListener;
            return this;
        }

        public Builder<K, V> setCacheLoader(CacheLoader<K, V> cacheLoader) {
            this.cacheLoader = cacheLoader;
            return this;
        }

        public Builder<K, V> setEvictionListener(RemovalListener<K, V> evictionListener) {
            this.userEvictionListener = evictionListener;
            return this;
        }

        public AsyncClaimingCacheImpl<K, V> build() {
            ConcurrentHashMap level1 = new ConcurrentHashMap();
            ConcurrentHashMap level3 = new ConcurrentHashMap();
            LinkedList evictionGuards = new LinkedList();
            RemovalListener level3AwareEvictionListener = (k, v, c) -> {
                boolean isGuarded = false;
                LinkedList linkedList = evictionGuards;
                synchronized (linkedList) {
                    for (Predicate evictionGuard : evictionGuards) {
                        isGuarded = evictionGuard.test(k);
                        if (!isGuarded) continue;
                        logger.debug("Protecting from eviction: " + String.valueOf(k) + " - " + level3.size() + " items protected");
                        level3.put(k, v);
                        break;
                    }
                }
                if (!isGuarded && this.userEvictionListener != null) {
                    this.userEvictionListener.onRemoval(k, v, c);
                }
            };
            this.caffeine.evictionListener((k, v, c) -> {
                Object kk = k;
                Object vv = v;
                if (!level1.containsKey(k)) {
                    level3AwareEvictionListener.onRemoval(kk, vv, c);
                }
            });
            CacheLoader level3AwareCacheLoader = k -> {
                Object[] tmp = new Object[]{null};
                level3.compute(k, (kk, v) -> {
                    tmp[0] = v;
                    return null;
                });
                Object r = tmp[0];
                if (r == null) {
                    r = this.cacheLoader.load(k);
                }
                return r;
            };
            AsyncLoadingCache level2 = this.caffeine.buildAsync(level3AwareCacheLoader);
            return new AsyncClaimingCacheImpl(level1, level2, level3, evictionGuards, this.claimListener, this.unclaimListener, level3AwareEvictionListener);
        }
    }
}

