/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.cache.plain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;

public class NavigableClamingCache<C extends Comparable<C>, V> {
    protected Cache<C, V> cache;
    protected NavigableSet<C> cacheKeys;
    protected NavigableMap<C, Ref<V>> claimed;

    public NavigableClamingCache(CacheBuilder<C, V> cacheBuilder) {
        cacheBuilder.removalListener(ev -> {
            NavigableClamingCache navigableClamingCache = this;
            synchronized (navigableClamingCache) {
                this.cacheKeys.remove(ev.getKey());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(C key, V value) {
        NavigableClamingCache navigableClamingCache = this;
        synchronized (navigableClamingCache) {
            this.cacheKeys.add(key);
            this.cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<C, Ref<V>> claimAll(Range<C> requestRange) {
        TreeMap<Comparable, Ref> result = new TreeMap<Comparable, Ref>();
        NavigableClamingCache navigableClamingCache = this;
        synchronized (navigableClamingCache) {
            NavigableMap<C, Ref<V>> tmp = NavigableClamingCache.filterByRange(this.claimed, requestRange);
            for (Map.Entry entry : tmp.entrySet()) {
                result.put((Comparable)entry.getKey(), ((Ref)entry.getValue()).acquire());
            }
            Set resultKeySet = result.keySet();
            NavigableSet<Comparable> keys = NavigableClamingCache.filterByRange(this.cacheKeys, requestRange);
            for (Comparable key : keys) {
                Object value;
                if (resultKeySet.contains(key) || (value = this.cache.getIfPresent((Object)key)) == null) continue;
                Ref rootRef = RefImpl.create((Object)value, (Object)this, () -> {
                    this.cache.put((Object)key, value);
                    this.claimed.remove(key);
                });
                result.put(key, rootRef.acquire());
                rootRef.close();
                this.claimed.put(key, rootRef);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> NavigableSet<T> filterByRange(NavigableSet<T> set, Range<T> range) {
        boolean isInclusive;
        Comparable endpoint;
        NavigableSet<Object> result = set;
        if (range.hasLowerBound()) {
            endpoint = range.lowerEndpoint();
            isInclusive = range.lowerBoundType().equals((Object)BoundType.CLOSED);
            result = result.tailSet(endpoint, isInclusive);
        }
        if (range.hasUpperBound()) {
            endpoint = range.upperEndpoint();
            isInclusive = range.upperBoundType().equals((Object)BoundType.CLOSED);
            result = result.headSet(endpoint, isInclusive);
        }
        return result;
    }

    public static <K extends Comparable<K>, V> NavigableMap<K, V> filterByRange(NavigableMap<K, V> map, Range<K> range) {
        boolean isInclusive;
        Comparable endpoint;
        NavigableMap<Comparable, V> result = map;
        if (range.hasLowerBound()) {
            endpoint = range.lowerEndpoint();
            isInclusive = range.lowerBoundType().equals((Object)BoundType.CLOSED);
            result = result.tailMap(endpoint, isInclusive);
        }
        if (range.hasUpperBound()) {
            endpoint = range.upperEndpoint();
            isInclusive = range.upperBoundType().equals((Object)BoundType.CLOSED);
            result = result.headMap(endpoint, isInclusive);
        }
        return result;
    }
}

