/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.cache.plain;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;

public class ClaimingCacheOld<K, V> {
    protected LoadingCache<K, Ref<V>> cache;
    protected Map<K, Ref<Ref<V>>> claimed;

    public static <K, V> ClaimingCacheOld<K, V> create(CacheBuilder<Object, Object> cacheBuilder, Function<K, Ref<V>> cacheLoader, RemovalListener<K, Ref<V>> removalListener) {
        return new ClaimingCacheOld<K, V>(cacheBuilder, cacheLoader, removalListener);
    }

    public ClaimingCacheOld(CacheBuilder<Object, Object> cacheBuilder, final Function<K, Ref<V>> cacheLoader, RemovalListener<K, Ref<V>> removalListener) {
        this.cache = cacheBuilder.removalListener(new RemovalListener<K, Ref<V>>(){

            public void onRemoval(RemovalNotification<K, Ref<V>> notification) {
                Ref primaryRef = (Ref)notification.getValue();
                primaryRef.close();
            }
        }).build(new CacheLoader<K, Ref<V>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Ref<V> load(K key) throws Exception {
                Ref primaryRef = null;
                Map map = ClaimingCacheOld.this.claimed;
                synchronized (map) {
                    Ref secondaryRef = ClaimingCacheOld.this.claimed.get(key);
                    if (secondaryRef != null) {
                        primaryRef = ((Ref)secondaryRef.get()).acquire();
                    }
                }
                if (primaryRef == null) {
                    primaryRef = (Ref)cacheLoader.apply(key);
                }
                return primaryRef;
            }
        });
        this.claimed = new HashMap<K, Ref<Ref<V>>>();
    }

    public <V> Ref<V> link(Ref<? extends Ref<V>> refToRef) {
        Ref tmpRef = refToRef.acquire();
        return RefImpl.create((Object)((Ref)tmpRef.get()).get(), this.claimed, () -> ((Ref)tmpRef).close());
    }

    public Ref<V> claimUnsafe(K key) {
        try {
            return this.claim(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref<V> claim(K key) throws ExecutionException {
        Ref secondaryRef;
        Ref<V> result = null;
        Map<K, Ref<Ref<V>>> map = this.claimed;
        synchronized (map) {
            secondaryRef = this.claimed.get(key);
            if (secondaryRef != null) {
                result = this.link(secondaryRef);
            }
        }
        if (secondaryRef == null) {
            Ref primaryRef = (Ref)this.cache.get(key);
            Map<K, Ref<Ref<V>>> map2 = this.claimed;
            synchronized (map2) {
                secondaryRef = this.claimed.get(key);
                if (secondaryRef == null) {
                    Ref tmpRef = primaryRef.acquire();
                    secondaryRef = RefImpl.create((Object)primaryRef, this.claimed, () -> {
                        Ref handBackRef = primaryRef.getRootRef().acquire();
                        this.cache.put(key, (Object)handBackRef);
                        this.claimed.remove(key);
                        tmpRef.close();
                    }, null);
                    result = this.link(secondaryRef);
                    secondaryRef.close();
                    this.claimed.put(key, secondaryRef);
                } else {
                    result = this.link(secondaryRef);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref<V> claimIfPresent(K key) {
        Ref<V> result = null;
        Map<K, Ref<Ref<V>>> map = this.claimed;
        synchronized (map) {
            if (this.claimed.containsKey(key) || this.cache.getIfPresent(key) != null) {
                result = this.claimUnsafe(key);
            }
        }
        return result;
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

