/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.beans.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class ReflectionUtils {
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Method result = null;
        try {
            result = clazz.getMethod(name, parameterTypes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Objects.requireNonNull(clazz, "Class must not be null");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            try {
                fields = searchType.getDeclaredFields();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + String.valueOf(clazz.getClassLoader()) + "]", ex);
            }
            for (Field field : fields) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }
}

