/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.beans.model;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.commons.lambda.throwing.ThrowingConsumer;
import org.aksw.commons.lambda.throwing.ThrowingFunction;
import org.aksw.commons.lambda.throwing.ThrowingSupplier;

public class PropertyUtils {
    public static <T> T applyIfPresent(ThrowingConsumer<? super T> setter, ThrowingSupplier<? extends T> getter) {
        return PropertyUtils.apply(false, setter, getter);
    }

    public static <T> T applyIfPresent(ThrowingFunction<? super T, ?> setter, ThrowingSupplier<? extends T> getter) {
        return PropertyUtils.apply(false, setter, getter);
    }

    public static <T> T apply(boolean setNull, ThrowingConsumer<? super T> setter, ThrowingSupplier<? extends T> getter) {
        try {
            Object result = getter.get();
            if (setNull || result != null) {
                setter.accept(result);
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T apply(boolean setNull, ThrowingFunction<? super T, ?> setter, ThrowingSupplier<? extends T> getter) {
        try {
            Object result = getter.get();
            if (setNull || result != null) {
                setter.apply(result);
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T applyIfAbsent(Consumer<? super T> targetSetter, Supplier<? extends T> targetGetter, Supplier<? extends T> valueGetter) {
        T result = targetGetter.get();
        if (result == null) {
            result = valueGetter.get();
            targetSetter.accept(result);
        }
        return result;
    }

    public static <T> T applyIfAbsent(Function<? super T, ?> targetSetter, Supplier<? extends T> targetGetter, Supplier<? extends T> valueGetter) {
        T result = targetGetter.get();
        if (result == null) {
            result = valueGetter.get();
            targetSetter.apply(result);
        }
        return result;
    }
}

